/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Map;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoredResponsesMap
extends MostRecentlyUsedMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private final Duration lifetime;

    public StoredResponsesMap(int maxEntries, Duration lifetime) {
        super(maxEntries);
        this.lifetime = lifetime;
    }

    protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
        Duration elapsedTime;
        Value value;
        boolean removed = super.removeEldestEntry(eldest);
        if (!removed && (value = (Value)eldest.getValue()) != null && this.lifetime.lessThanOrEqual((LongValue)(elapsedTime = Time.now().subtract(value.creationTime)))) {
            this.removedValue = value.response;
            removed = true;
        }
        return removed;
    }

    public BufferedWebResponse put(String key, Object bufferedResponse) {
        if (!(bufferedResponse instanceof BufferedWebResponse)) {
            throw new IllegalArgumentException(StoredResponsesMap.class.getSimpleName() + " can store only instances of " + BufferedWebResponse.class.getSimpleName());
        }
        Value value = new Value();
        value.creationTime = Time.now();
        value.response = (BufferedWebResponse)bufferedResponse;
        Value oldValue = (Value)super.put((Object)key, (Object)value);
        return oldValue != null ? oldValue.response : null;
    }

    public BufferedWebResponse get(Object key) {
        BufferedWebResponse result = null;
        Value value = (Value)super.get(key);
        if (value != null) {
            Duration elapsedTime = Time.now().subtract(value.creationTime);
            if (this.lifetime.greaterThan((LongValue)elapsedTime)) {
                result = value.response;
            } else {
                this.remove(key);
            }
        }
        return result;
    }

    public BufferedWebResponse remove(Object key) {
        Value removedValue = (Value)super.remove(key);
        return removedValue != null ? removedValue.response : null;
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    private static class Value {
        private BufferedWebResponse response;
        private Time creationTime;

        private Value() {
        }
    }
}

