/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestLogger
implements IRequestLogger {
    protected static Logger log = LoggerFactory.getLogger(RequestLogger.class);
    private static MetaDataKey<IRequestLogger.RequestData> REQUEST_DATA = new MetaDataKey<IRequestLogger.RequestData>(){
        private static final long serialVersionUID = 1L;
    };
    private final AtomicInteger totalCreatedSessions = new AtomicInteger();
    private final AtomicInteger peakSessions = new AtomicInteger();
    private final List<IRequestLogger.RequestData> requests;
    private final Map<String, IRequestLogger.SessionData> liveSessions;
    private final AtomicInteger activeRequests = new AtomicInteger();
    private final AtomicInteger peakActiveRequests = new AtomicInteger();

    public RequestLogger() {
        this.requests = Collections.synchronizedList(new LinkedList<IRequestLogger.RequestData>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void add(int index, IRequestLogger.RequestData o) {
                super.add(index, o);
                if (this.size() > Application.get().getRequestLoggerSettings().getRequestsWindowSize()) {
                    this.removeLast();
                }
            }
        });
        this.liveSessions = new ConcurrentHashMap<String, IRequestLogger.SessionData>();
    }

    @Override
    public int getCurrentActiveRequestCount() {
        return this.activeRequests.get();
    }

    @Override
    public int getPeakActiveRequestCount() {
        return this.peakActiveRequests.get();
    }

    @Override
    public IRequestLogger.SessionData[] getLiveSessions() {
        Object[] sessions = this.liveSessions.values().toArray(new IRequestLogger.SessionData[this.liveSessions.values().size()]);
        Arrays.sort(sessions);
        return sessions;
    }

    @Override
    public int getPeakSessions() {
        return this.peakSessions.get();
    }

    @Override
    public List<IRequestLogger.RequestData> getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    @Override
    public int getTotalCreatedSessions() {
        return this.totalCreatedSessions.get();
    }

    @Override
    public void logEventTarget(IRequestHandler requestHandler) {
        this.getCurrentRequest().addEventTarget(this.getRequestHandlerString(requestHandler));
    }

    @Override
    public void logResponseTarget(IRequestHandler requestHandler) {
        this.getCurrentRequest().addResponseTarget(this.getRequestHandlerString(requestHandler));
    }

    private String getRequestHandlerString(IRequestHandler requestHandler) {
        AppendingStringBuffer sb = new AppendingStringBuffer(128);
        if (requestHandler instanceof ListenerInterfaceRequestHandler) {
            ListenerInterfaceRequestHandler listener = (ListenerInterfaceRequestHandler)requestHandler;
            sb.append("Interface[component: ");
            sb.append(Classes.simpleName(listener.getComponent().getClass()));
            sb.append("(");
            sb.append(listener.getComponent().getPageRelativePath());
            sb.append("), page: ");
            sb.append(listener.getPage().getClass().getName());
            sb.append("(");
            sb.append(listener.getPage().getId());
            sb.append("), interface: ");
            sb.append(listener.getListenerInterface().getName());
            sb.append(".");
            sb.append(listener.getListenerInterface().getMethod().getName());
            sb.append("]");
        } else if (requestHandler instanceof BookmarkablePageRequestHandler) {
            BookmarkablePageRequestHandler pageRequestHandler = (BookmarkablePageRequestHandler)requestHandler;
            sb.append("BookmarkablePage[");
            sb.append(pageRequestHandler.getPageClass().getName());
            sb.append("(").append((Object)pageRequestHandler.getPageParameters()).append(")");
            sb.append("]");
        } else if (requestHandler instanceof IPageRequestHandler) {
            IPageRequestHandler pageRequestHandler = (IPageRequestHandler)requestHandler;
            sb.append("PageRequest[");
            sb.append(pageRequestHandler.getPage().getClass().getName());
            sb.append("(");
            sb.append(pageRequestHandler.getPage().getId());
            sb.append(")]");
        } else if (requestHandler instanceof ResourceReferenceRequestHandler) {
            ResourceReferenceRequestHandler resourceRefenceHandler = (ResourceReferenceRequestHandler)requestHandler;
            sb.append("ResourceReference[");
            sb.append((Object)resourceRefenceHandler.getResourceReference());
            sb.append("]");
        } else if (requestHandler instanceof IRequestHandlerDelegate) {
            sb.append(requestHandler.getClass().getSimpleName()).append(".").append(this.getRequestHandlerString(((IRequestHandlerDelegate)requestHandler).getDelegateHandler()));
        } else {
            sb.append(requestHandler.toString());
        }
        return sb.toString();
    }

    @Override
    public void objectCreated(Object value) {
        IRequestLogger.RequestData rd = this.getCurrentRequest();
        if (value instanceof Session) {
            rd.addEntry("Session created");
        } else if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page created, id: " + page.getId() + ", class:" + page.getClass());
        } else {
            rd.addEntry("Custom object created: " + value);
        }
    }

    @Override
    public void objectRemoved(Object value) {
        IRequestLogger.RequestData rd = this.getCurrentRequest();
        if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page removed, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof WebSession) {
            rd.addEntry("Session removed");
        } else {
            rd.addEntry("Custom object removed: " + value);
        }
    }

    @Override
    public void objectUpdated(Object value) {
        IRequestLogger.RequestData rd = this.getCurrentRequest();
        if (value instanceof Page) {
            Page page = (Page)value;
            rd.addEntry("Page updated, id: " + page.getId() + ", class:" + page.getClass());
        } else if (value instanceof Session) {
            rd.addEntry("Session updated");
        } else {
            rd.addEntry("Custom object updated: " + value);
        }
    }

    @Override
    public void requestTime(long timeTaken) {
        IRequestLogger.RequestData rd = RequestCycle.get().getMetaData(REQUEST_DATA);
        if (rd != null) {
            if (this.activeRequests.get() > 0) {
                rd.setActiveRequest(this.activeRequests.decrementAndGet());
            }
            Session session = Session.get();
            String sessionId = session.getId();
            rd.setSessionId(sessionId);
            Object sessionInfo = this.getSessionInfo(session);
            rd.setSessionInfo(sessionInfo);
            long sizeInBytes = -1L;
            if (Application.get().getRequestLoggerSettings().getRecordSessionSize()) {
                try {
                    sizeInBytes = session.getSizeInBytes();
                }
                catch (Exception e) {
                    log.error("Exception while determining the size of the session in the request logger: " + e.getMessage(), (Throwable)e);
                }
            }
            rd.setSessionSize(sizeInBytes);
            rd.setTimeTaken(timeTaken);
            this.requests.add(0, rd);
            if (sessionId != null) {
                IRequestLogger.SessionData sd = this.liveSessions.get(sessionId);
                if (sd == null) {
                    this.sessionCreated(sessionId);
                    sd = this.liveSessions.get(sessionId);
                }
                if (sd != null) {
                    sd.setSessionInfo(sessionInfo);
                    sd.setSessionSize(sizeInBytes);
                    sd.addTimeTaken(timeTaken);
                    this.log(rd, sd);
                } else {
                    this.log(rd, null);
                }
            } else {
                this.log(rd, null);
            }
        }
    }

    @Override
    public void sessionCreated(String sessionId) {
        this.liveSessions.put(sessionId, new IRequestLogger.SessionData(sessionId));
        if (this.liveSessions.size() > this.peakSessions.get()) {
            this.peakSessions.set(this.liveSessions.size());
        }
        this.totalCreatedSessions.incrementAndGet();
    }

    @Override
    public void sessionDestroyed(String sessionId) {
        this.liveSessions.remove(sessionId);
    }

    IRequestLogger.RequestData getCurrentRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestLogger.RequestData rd = requestCycle.getMetaData(REQUEST_DATA);
        if (rd == null) {
            rd = new IRequestLogger.RequestData();
            requestCycle.setMetaData(REQUEST_DATA, rd);
            int activeCount = this.activeRequests.incrementAndGet();
            if (activeCount > this.peakActiveRequests.get()) {
                this.peakActiveRequests.set(activeCount);
            }
        }
        return rd;
    }

    protected void log(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        if (log.isInfoEnabled()) {
            log.info(this.createLogString(rd, sd, true).toString());
        }
    }

    protected final AppendingStringBuffer createLogString(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd, boolean includeRuntimeInfo) {
        AppendingStringBuffer asb = new AppendingStringBuffer(150);
        asb.append("time=");
        asb.append((Object)rd.getTimeTaken());
        asb.append(",event=");
        asb.append(rd.getEventTarget());
        asb.append(",response=");
        asb.append(rd.getResponseTarget());
        if (rd.getSessionInfo() != null && !rd.getSessionInfo().equals("")) {
            asb.append(",sessioninfo=");
            asb.append(rd.getSessionInfo());
        } else {
            asb.append(",sessionid=");
            asb.append(rd.getSessionId());
        }
        asb.append(",sessionsize=");
        asb.append((Object)rd.getSessionSize());
        if (sd != null) {
            asb.append(",sessionstart=");
            asb.append((Object)sd.getStartDate());
            asb.append(",requests=");
            asb.append(sd.getNumberOfRequests());
            asb.append(",totaltime=");
            asb.append(sd.getTotalTimeTaken());
        }
        asb.append(",activerequests=");
        asb.append(rd.getActiveRequest());
        if (includeRuntimeInfo) {
            Runtime runtime = Runtime.getRuntime();
            long max = runtime.maxMemory() / 1000000L;
            long total = runtime.totalMemory() / 1000000L;
            long used = total - runtime.freeMemory() / 1000000L;
            asb.append(",maxmem=");
            asb.append(max);
            asb.append("M,total=");
            asb.append(total);
            asb.append("M,used=");
            asb.append(used);
            asb.append("M");
        }
        return asb;
    }

    private Object getSessionInfo(Session session) {
        if (session instanceof IRequestLogger.ISessionLogInfo) {
            return ((IRequestLogger.ISessionLogInfo)((Object)session)).getSessionInfo();
        }
        return "";
    }
}

