/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelPool {
    private static final Logger log = LoggerFactory.getLogger(FileChannelPool.class);
    private final Map<String, FileChannel> nameToChannel = new HashMap<String, FileChannel>();
    private final Map<FileChannel, String> channelToName = new HashMap<FileChannel, String>();
    private final Map<FileChannel, Integer> channelToUseCount = new HashMap<FileChannel, Integer>();
    private final LinkedList<FileChannel> idleChannels = new LinkedList();
    private final Set<FileChannel> channelsToDeleteOnReturn = new HashSet<FileChannel>();
    private final int capacity;

    public FileChannelPool(int capacity) {
        this.capacity = capacity;
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least one.");
        }
        log.debug("Starting file channel pool with capacity of '{}' channels", (Object)capacity);
    }

    private FileChannel newFileChannel(String fileName, boolean createIfDoesNotExist) {
        File file = new File(fileName);
        if (!file.exists() && !createIfDoesNotExist) {
            return null;
        }
        try {
            return new RandomAccessFile(file, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void reduceChannels() {
        int channelsToReduce;
        for (channelsToReduce = this.nameToChannel.size() - this.capacity + 1; channelsToReduce > 0 && !this.idleChannels.isEmpty(); --channelsToReduce) {
            FileChannel channel = this.idleChannels.removeFirst();
            String channelName = this.channelToName.get(channel);
            this.nameToChannel.remove(channelName);
            this.channelToName.remove(channel);
            if (this.channelToUseCount.get(channel) != null) {
                log.warn("Channel " + channelName + " is both idle and in use at the same time!");
                this.channelToUseCount.remove(channel);
            }
            try {
                channel.close();
                continue;
            }
            catch (IOException e) {
                log.error("Error closing file channel", (Throwable)e);
            }
        }
        if (channelsToReduce > 0) {
            log.warn("Unable to reduce enough channels, no idle channels left to remove.");
        }
    }

    public synchronized FileChannel getFileChannel(String fileName, boolean createIfDoesNotExist) {
        FileChannel channel = this.nameToChannel.get(fileName);
        if (channel == null && (channel = this.newFileChannel(fileName, createIfDoesNotExist)) != null) {
            if (this.nameToChannel.size() >= this.capacity) {
                this.reduceChannels();
            }
            this.nameToChannel.put(fileName, channel);
            this.channelToName.put(channel, fileName);
        }
        if (channel != null) {
            Integer count = this.channelToUseCount.get(channel);
            if (count == null || count == 0) {
                this.channelToUseCount.put(channel, 1);
                this.idleChannels.remove(channel);
            } else {
                count = count + 1;
                this.channelToUseCount.put(channel, count);
            }
        }
        return channel;
    }

    public synchronized void returnFileChannel(FileChannel channel) {
        Integer count = this.channelToUseCount.get(channel);
        if (count == null || count == 0) {
            throw new IllegalArgumentException("Trying to return unused channel");
        }
        if ((count = Integer.valueOf(count - 1)) == 0) {
            this.channelToUseCount.remove(channel);
            if (this.channelsToDeleteOnReturn.contains(channel)) {
                this.closeAndDelete(channel);
            } else {
                this.idleChannels.addLast(channel);
            }
        } else {
            this.channelToUseCount.put(channel, count);
        }
    }

    private void closeAndDelete(FileChannel channel) {
        this.channelsToDeleteOnReturn.remove(channel);
        String name = this.channelToName.get(channel);
        this.channelToName.remove(channel);
        this.channelToUseCount.remove(channel);
        this.idleChannels.remove(channel);
        try {
            channel.close();
        }
        catch (IOException e) {
            log.error("Error closing file channel", (Throwable)e);
        }
        File file = new File(name);
        Files.remove((File)file);
    }

    public synchronized void closeAndDeleteFileChannel(String name) {
        FileChannel channel = this.nameToChannel.get(name);
        if (channel != null) {
            this.nameToChannel.remove(name);
            Integer count = this.channelToUseCount.get(channel);
            if (count != null && count > 0) {
                this.channelsToDeleteOnReturn.add(channel);
            } else {
                this.closeAndDelete(channel);
            }
        } else {
            File file = new File(name);
            Files.remove((File)file);
        }
    }

    public synchronized void destroy() {
        log.debug("Destroying FileChannel pool");
        for (FileChannel channel : this.channelToName.keySet()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                log.error("Error closing file channel", (Throwable)e);
            }
        }
    }
}

