/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;

public class DefaultPageStore
implements IPageStore {
    private final SerializedPagesCache serializedPagesCache;
    private final IDataStore pageDataStore;
    private final ISerializer pageSerializer;

    public DefaultPageStore(ISerializer pageSerializer, IDataStore dataStore, int cacheSize) {
        Args.notNull((Object)pageSerializer, (String)"pageSerializer");
        Args.notNull((Object)dataStore, (String)"DataStore");
        this.pageSerializer = pageSerializer;
        this.pageDataStore = dataStore;
        this.serializedPagesCache = new SerializedPagesCache(cacheSize);
    }

    public void destroy() {
        this.pageDataStore.destroy();
    }

    protected byte[] getPageData(String sessionId, int pageId) {
        return this.pageDataStore.getData(sessionId, pageId);
    }

    protected void removePageData(String sessionId, int pageId) {
        this.pageDataStore.removeData(sessionId, pageId);
    }

    protected void removePageData(String sessionId) {
        this.pageDataStore.removeData(sessionId);
    }

    protected void storePageData(String sessionId, int pageId, byte[] data) {
        this.pageDataStore.storeData(sessionId, pageId, data);
    }

    public IManageablePage getPage(String sessionId, int id) {
        SerializedPage fromCache = this.serializedPagesCache.getPage(sessionId, id);
        if (fromCache != null) {
            return this.deserializePage(fromCache.data);
        }
        byte[] data = this.getPageData(sessionId, id);
        if (data != null) {
            return this.deserializePage(data);
        }
        return null;
    }

    public void removePage(String sessionId, int id) {
        this.serializedPagesCache.removePage(sessionId, id);
        this.removePageData(sessionId, id);
    }

    public void storePage(String sessionId, IManageablePage page) {
        SerializedPage serialized = this.serializePage(sessionId, page);
        this.serializedPagesCache.storePage(serialized);
        this.storePageData(sessionId, serialized.getPageId(), serialized.getData());
    }

    public void unbind(String sessionId) {
        this.removePageData(sessionId);
        this.serializedPagesCache.removePages(sessionId);
    }

    public IManageablePage convertToPage(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IManageablePage) {
            return (IManageablePage)object;
        }
        if (object instanceof SerializedPage) {
            SerializedPage page = (SerializedPage)object;
            byte[] data = page.getData();
            if (data == null) {
                data = this.getPageData(page.getSessionId(), page.getPageId());
            }
            if (data != null) {
                return this.deserializePage(data);
            }
            return null;
        }
        String type = object.getClass().getName();
        throw new IllegalArgumentException("Unknown object type " + type);
    }

    private SerializedPage restoreStrippedSerializedPage(SerializedPage serializedPage) {
        SerializedPage result = this.serializedPagesCache.getPage(serializedPage.getSessionId(), serializedPage.getPageId());
        if (result != null) {
            return result;
        }
        byte[] data = this.getPageData(serializedPage.getSessionId(), serializedPage.getPageId());
        return new SerializedPage(serializedPage.getSessionId(), serializedPage.getPageId(), data);
    }

    public Serializable prepareForSerialization(String sessionId, Object object) {
        if (this.pageDataStore.isReplicated()) {
            return null;
        }
        SerializedPage result = null;
        if (object instanceof IManageablePage) {
            IManageablePage page = (IManageablePage)object;
            result = this.serializedPagesCache.getPage(sessionId, page.getPageId());
            if (result == null) {
                result = this.serializePage(sessionId, page);
                this.serializedPagesCache.storePage(result);
            }
        } else if (object instanceof SerializedPage) {
            SerializedPage page = (SerializedPage)object;
            result = page.getData() == null ? this.restoreStrippedSerializedPage(page) : page;
        }
        if (result != null) {
            return result;
        }
        return (Serializable)object;
    }

    protected boolean storeAfterSessionReplication() {
        return true;
    }

    public Object restoreAfterSerialization(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        if (!this.storeAfterSessionReplication() || serializable instanceof IManageablePage) {
            return serializable;
        }
        if (serializable instanceof SerializedPage) {
            SerializedPage page = (SerializedPage)serializable;
            if (page.getData() != null) {
                this.storePageData(page.getSessionId(), page.getPageId(), page.getData());
                return new SerializedPage(page.getSessionId(), page.getPageId(), null);
            }
            return page;
        }
        String type = serializable.getClass().getName();
        throw new IllegalArgumentException("Unknown object type " + type);
    }

    protected SerializedPage serializePage(String sessionId, IManageablePage page) {
        Args.notNull((Object)sessionId, (String)"sessionId");
        Args.notNull((Object)page, (String)"page");
        byte[] data = this.pageSerializer.serialize((Object)page);
        return new SerializedPage(sessionId, page.getPageId(), data);
    }

    protected IManageablePage deserializePage(byte[] data) {
        IManageablePage page = (IManageablePage)this.pageSerializer.deserialize(data);
        return page;
    }

    static class SerializedPagesCache {
        private final int size;
        private final List<SoftReference<SerializedPage>> cache;

        public SerializedPagesCache(int size) {
            this.size = size;
            this.cache = new ArrayList<SoftReference<SerializedPage>>(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SerializedPage removePage(String sessionId, int id) {
            Args.notNull((Object)sessionId, (String)"sessionId");
            if (this.size > 0) {
                List<SoftReference<SerializedPage>> list = this.cache;
                synchronized (list) {
                    Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                    while (i.hasNext()) {
                        SoftReference<SerializedPage> ref = i.next();
                        SerializedPage entry = ref.get();
                        if (entry == null || entry.getPageId() != id || !entry.getSessionId().equals(sessionId)) continue;
                        i.remove();
                        return entry;
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePages(String sessionId) {
            Args.notNull((Object)sessionId, (String)"sessionId");
            if (this.size > 0) {
                List<SoftReference<SerializedPage>> list = this.cache;
                synchronized (list) {
                    Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                    while (i.hasNext()) {
                        SoftReference<SerializedPage> ref = i.next();
                        SerializedPage entry = ref.get();
                        if (entry == null || !entry.getSessionId().equals(sessionId)) continue;
                        i.remove();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SerializedPage getPage(String sessionId, int pageId) {
            Args.notNull((Object)sessionId, (String)"sessionId");
            SerializedPage result = null;
            if (this.size > 0) {
                List<SoftReference<SerializedPage>> list = this.cache;
                synchronized (list) {
                    Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                    while (i.hasNext()) {
                        SoftReference<SerializedPage> ref = i.next();
                        SerializedPage entry = ref.get();
                        if (entry == null || entry.getPageId() != pageId || !entry.getSessionId().equals(sessionId)) continue;
                        i.remove();
                        result = entry;
                        break;
                    }
                    if (result != null) {
                        this.storePage(result);
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storePage(SerializedPage page) {
            SoftReference<SerializedPage> ref = new SoftReference<SerializedPage>(page);
            if (this.size > 0) {
                List<SoftReference<SerializedPage>> list = this.cache;
                synchronized (list) {
                    Iterator<SoftReference<SerializedPage>> i = this.cache.iterator();
                    while (i.hasNext()) {
                        SoftReference<SerializedPage> r = i.next();
                        SerializedPage entry = r.get();
                        if (entry == null || !entry.equals(page)) continue;
                        i.remove();
                        break;
                    }
                    this.cache.add(ref);
                    if (this.cache.size() > this.size) {
                        this.cache.remove(0);
                    }
                }
            }
        }
    }

    protected static class SerializedPage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int pageId;
        private final String sessionId;
        private final byte[] data;

        public SerializedPage(String sessionId, int pageId, byte[] data) {
            this.pageId = pageId;
            this.sessionId = sessionId;
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getPageId() {
            return this.pageId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SerializedPage)) {
                return false;
            }
            SerializedPage rhs = (SerializedPage)obj;
            return Objects.equal((Object)this.getPageId(), (Object)rhs.getPageId()) && Objects.equal((Object)this.getSessionId(), (Object)rhs.getSessionId());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getPageId(), this.getSessionId()});
        }
    }
}

