/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousDataStore
implements IDataStore {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousDataStore.class);
    private static final long OFFER_WAIT = 30L;
    private static final long POLL_WAIT = 1000L;
    private final AtomicBoolean destroy;
    private final IDataStore dataStore;
    private final BlockingQueue<Entry> entries;
    private final ConcurrentMap<String, Entry> entryMap;

    public AsynchronousDataStore(IDataStore dataStore, int capacity) {
        this.dataStore = dataStore;
        this.destroy = new AtomicBoolean(false);
        this.entries = new LinkedBlockingQueue<Entry>(capacity);
        this.entryMap = new ConcurrentHashMap<String, Entry>();
        PageSavingRunnable savingRunnable = new PageSavingRunnable(dataStore, this.entries, this.entryMap, this.destroy);
        new Thread((Runnable)savingRunnable, "Wicket-PageSavingThread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroy.set(true);
        try {
            AtomicBoolean atomicBoolean = this.destroy;
            synchronized (atomicBoolean) {
                this.destroy.wait();
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.dataStore.destroy();
    }

    private Entry getEntry(String sessionId, int id) {
        return (Entry)this.entryMap.get(AsynchronousDataStore.getKey(sessionId, id));
    }

    public byte[] getData(String sessionId, int id) {
        Entry entry = this.getEntry(sessionId, id);
        if (entry != null) {
            log.debug("Returning the data of a non-stored entry with sessionId '{}' and pageId '{}'", (Object)sessionId, (Object)id);
            return entry.getData();
        }
        byte[] data = this.dataStore.getData(sessionId, id);
        log.debug("Returning the data of a stored entry with sessionId '{}' and pageId '{}'", (Object)sessionId, (Object)id);
        return data;
    }

    public boolean isReplicated() {
        return this.dataStore.isReplicated();
    }

    public void removeData(String sessionId, int id) {
        Entry entry;
        String key = AsynchronousDataStore.getKey(sessionId, id);
        if (key != null && (entry = (Entry)this.entryMap.remove(key)) != null) {
            this.entries.remove(entry);
        }
        this.dataStore.removeData(sessionId, id);
    }

    public void removeData(String sessionId) {
        Entry[] entriesCopy;
        for (Entry entry : entriesCopy = this.entries.toArray(new Entry[this.entries.size()])) {
            if (!entry.getSessionId().equals(sessionId)) continue;
            this.entryMap.remove(AsynchronousDataStore.getKey(entry));
            this.entries.remove(entry);
        }
        this.dataStore.removeData(sessionId);
    }

    public void storeData(String sessionId, int id, byte[] data) {
        Entry entry = new Entry(sessionId, id, data);
        try {
            boolean added = this.entries.offer(entry, 30L, TimeUnit.MILLISECONDS);
            if (!added) {
                log.debug("Storing synchronously page with id '{}' in session '{}'", (Object)id, (Object)sessionId);
                this.dataStore.storeData(sessionId, id, data);
            } else {
                this.entryMap.put(AsynchronousDataStore.getKey(entry), entry);
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.dataStore.storeData(sessionId, id, data);
        }
    }

    private static String getKey(String sessionId, int pageId) {
        return pageId + ":::" + sessionId;
    }

    private static String getKey(Entry entry) {
        return AsynchronousDataStore.getKey(entry.getSessionId(), entry.getPageId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PageSavingRunnable
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(PageSavingRunnable.class);
        private final AtomicBoolean destroy;
        private final BlockingQueue<Entry> entries;
        private final ConcurrentMap<String, Entry> entryMap;
        private final IDataStore dataStore;

        private PageSavingRunnable(IDataStore dataStore, BlockingQueue<Entry> entries, ConcurrentMap<String, Entry> entryMap, AtomicBoolean destroy) {
            this.dataStore = dataStore;
            this.entries = entries;
            this.entryMap = entryMap;
            this.destroy = destroy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.destroy.get()) {
                Entry entry = null;
                try {
                    entry = this.entries.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (entry == null) continue;
                log.debug("Saving asynchronously: {}...", (Object)entry);
                this.dataStore.storeData(entry.getSessionId(), entry.getPageId(), entry.getData());
                this.entryMap.remove(AsynchronousDataStore.getKey(entry));
            }
            AtomicBoolean atomicBoolean = this.destroy;
            synchronized (atomicBoolean) {
                this.destroy.notify();
            }
        }
    }

    private static class Entry {
        private final String sessionId;
        private final int pageId;
        private final byte[] data;

        public Entry(String sessionId, int pageId, byte[] data) {
            this.sessionId = (String)Args.notNull((Object)sessionId, (String)"sessionId");
            this.pageId = pageId;
            this.data = (byte[])Args.notNull((Object)data, (String)"data");
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public int getPageId() {
            return this.pageId;
        }

        public byte[] getData() {
            return this.data;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pageId;
            result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.pageId != other.pageId) {
                return false;
            }
            return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
        }

        public String toString() {
            return "Entry [sessionId=" + this.sessionId + ", pageId=" + this.pageId + "]";
        }
    }
}

