/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.page.CouldNotLockPageException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.PageManagerDecorator;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.LazyInitializer;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageAccessSynchronizer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PageAccessSynchronizer.class);
    private IProvider<ConcurrentMap<Integer, PageLock>> locks = new LazyInitializer<ConcurrentMap<Integer, PageLock>>(){
        private static final long serialVersionUID = 1L;

        protected ConcurrentMap<Integer, PageLock> createInstance() {
            return new ConcurrentHashMap<Integer, PageLock>();
        }
    };
    private final Duration timeout;

    public PageAccessSynchronizer(Duration timeout) {
        this.timeout = timeout;
    }

    private static long remaining(Time start, Duration timeout) {
        return Math.max(0L, timeout.subtract(start.elapsedSince()).getMilliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockPage(int pageId) throws CouldNotLockPageException {
        Thread thread = Thread.currentThread();
        PageLock lock = new PageLock(pageId, thread);
        Time start = Time.now();
        boolean locked = false;
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (!locked && start.elapsedSince().lessThan((LongValue)this.timeout)) {
            PageLock previous;
            if (isDebugEnabled) {
                logger.debug("'{}' attempting to acquire lock to page with id '{}'", (Object)thread.getName(), (Object)pageId);
            }
            if ((previous = ((ConcurrentMap)this.locks.get()).putIfAbsent(pageId, lock)) == null || previous.getThread() == thread) {
                locked = true;
                continue;
            }
            long remaining = PageAccessSynchronizer.remaining(start, this.timeout);
            if (remaining <= 0L) continue;
            PageLock pageLock = previous;
            synchronized (pageLock) {
                if (isDebugEnabled) {
                    logger.debug("{} waiting for lock to page {} for {}", new Object[]{thread.getName(), pageId, Duration.milliseconds((long)remaining)});
                }
                try {
                    previous.wait(remaining);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (locked) {
            if (isDebugEnabled) {
                logger.debug("{} acquired lock to page {}", (Object)thread.getName(), (Object)pageId);
            }
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("{} failed to acquire lock to page {}, attempted for {} out of allowed {}", new Object[]{thread.getName(), pageId, start.elapsedSince(), this.timeout});
            }
            throw new CouldNotLockPageException(pageId, thread.getName(), this.timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAllPages() {
        Thread thread = Thread.currentThread();
        Iterator locks = ((ConcurrentMap)this.locks.get()).values().iterator();
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (locks.hasNext()) {
            PageLock lock = (PageLock)locks.next();
            if (lock.getThread() != thread) continue;
            locks.remove();
            if (isDebugEnabled) {
                logger.debug("{} released lock to page {}", (Object)thread.getName(), (Object)lock.getPageId());
            }
            PageLock pageLock = lock;
            synchronized (pageLock) {
                if (isDebugEnabled) {
                    logger.debug("{} notifying blocked threads", (Object)thread.getName());
                }
                lock.notifyAll();
            }
        }
    }

    public IPageManager adapt(IPageManager pagemanager) {
        return new PageManagerDecorator(pagemanager){

            public IManageablePage getPage(int id) {
                PageAccessSynchronizer.this.lockPage(id);
                return super.getPage(id);
            }

            public void touchPage(IManageablePage page) {
                PageAccessSynchronizer.this.lockPage(page.getPageId());
                super.touchPage(page);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commitRequest() {
                try {
                    super.commitRequest();
                }
                finally {
                    PageAccessSynchronizer.this.unlockAllPages();
                }
            }
        };
    }

    public static class PageLock {
        private final int pageId;
        private final Thread thread;

        public PageLock(int pageId, Thread thread) {
            this.pageId = pageId;
            this.thread = thread;
        }

        public int getPageId() {
            return this.pageId;
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

