/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.IChainingModel;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundPropertyModel<T>
implements IComponentInheritedModel<T>,
IChainingModel<T> {
    private static final long serialVersionUID = 1L;
    private Object target;

    public CompoundPropertyModel(IModel<T> model) {
        this.target = model;
    }

    public CompoundPropertyModel(T object) {
        this.target = object;
    }

    @Override
    public T getObject() {
        if (this.target instanceof IModel) {
            return ((IModel)this.target).getObject();
        }
        return (T)this.target;
    }

    @Override
    public void setObject(T object) {
        if (this.target instanceof IModel) {
            ((IModel)this.target).setObject(object);
        } else {
            this.target = object;
        }
    }

    @Override
    public IModel<?> getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    @Override
    public void setChainedModel(IModel<?> model) {
        this.target = model;
    }

    @Override
    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    protected String propertyExpression(Component component) {
        return component.getId();
    }

    @Override
    public <C> IWrapModel<C> wrapOnInheritance(Component component) {
        return new AttachedCompoundPropertyModel(component);
    }

    public <S> IModel<S> bind(String property) {
        return new PropertyModel(this, property);
    }

    public String toString() {
        AppendingStringBuffer sb = new AppendingStringBuffer().append("Model:classname=[" + this.getClass().getName() + "]");
        sb.append(":nestedModel=[").append(this.target).append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttachedCompoundPropertyModel<C>
    extends AbstractPropertyModel<C>
    implements IWrapModel<C> {
        private static final long serialVersionUID = 1L;
        private final Component owner;

        public AttachedCompoundPropertyModel(Component owner) {
            super(CompoundPropertyModel.this);
            this.owner = owner;
        }

        @Override
        protected String propertyExpression() {
            return CompoundPropertyModel.this.propertyExpression(this.owner);
        }

        @Override
        public IModel<T> getWrappedModel() {
            return CompoundPropertyModel.this;
        }

        @Override
        public void detach() {
            super.detach();
            CompoundPropertyModel.this.detach();
        }
    }
}

