/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockWebResponse
extends WebResponse {
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String redirectUrl;
    private Long contentLength;
    private String contentType;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    Integer status;
    private StringBuilder textResponse;
    private ByteArrayOutputStream binaryResponse;
    String errorMessage;

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void clearCookie(Cookie cookie) {
        this.cookies.remove(cookie);
    }

    public List<Cookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    public void sendRedirect(String url) {
        this.redirectUrl = url;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean isRedirect() {
        return this.redirectUrl != null;
    }

    public void setContentLength(long length) {
        this.contentLength = length;
        this.setHeader("Content-Length", String.valueOf(length));
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String mimeType) {
        this.contentType = mimeType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setDateHeader(String name, Time date) {
        Args.notNull((Object)date, (String)"date");
        this.headers.put(name, date);
    }

    public Time getDateHeader(String name) {
        Object value = this.headers.get(name);
        if (value == null) {
            throw new WicketRuntimeException("Date header '" + name + "' is not set.");
        }
        if (!(value instanceof Time)) {
            throw new WicketRuntimeException("Header '" + name + "' is not date type.");
        }
        return (Time)value;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
        if (name.equals("Content-Type")) {
            this.setContentType(value);
        }
    }

    public String getHeader(String name) {
        Object value = this.headers.get(name);
        return value != null ? value.toString() : null;
    }

    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String encodeURL(CharSequence url) {
        return ((Object)url).toString();
    }

    public void write(CharSequence sequence) {
        if (this.binaryResponse != null) {
            throw new IllegalStateException("Binary response has already been initiated.");
        }
        if (this.textResponse == null) {
            this.textResponse = new StringBuilder();
        }
        this.textResponse.append(sequence);
    }

    public CharSequence getTextResponse() {
        return this.textResponse;
    }

    public void write(byte[] array) {
        if (this.textResponse != null) {
            throw new IllegalStateException("Text response has already been initiated.");
        }
        if (this.binaryResponse == null) {
            this.binaryResponse = new ByteArrayOutputStream();
        }
        try {
            this.binaryResponse.write(array);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getBinaryResponse() {
        if (this.binaryResponse == null) {
            return null;
        }
        byte[] bytes = this.binaryResponse.toByteArray();
        if (this.getContentLength() != null) {
            byte[] trimmed = new byte[this.getContentLength().intValue()];
            System.arraycopy(bytes, 0, trimmed, 0, this.getContentLength().intValue());
            return trimmed;
        }
        return bytes;
    }

    public void sendError(int sc, String msg) {
        this.status = sc;
        this.errorMessage = msg;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void flush() {
    }

    public void reset() {
        super.reset();
        if (this.binaryResponse != null) {
            this.binaryResponse = new ByteArrayOutputStream();
        }
        this.contentLength = null;
        this.contentType = null;
        if (this.cookies != null) {
            this.cookies.clear();
        }
        this.errorMessage = null;
        if (this.headers != null) {
            this.headers.clear();
        }
        this.redirectUrl = null;
        this.status = null;
        if (this.textResponse != null) {
            this.textResponse.setLength(0);
        }
    }

    public Object getContainerResponse() {
        return this;
    }
}

