/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.transformer.ITransformer;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

public abstract class AbstractTransformerBehavior
extends Behavior
implements ITransformer {
    private static final long serialVersionUID = 1L;
    private WebResponse webResponse;

    protected BufferedWebResponse newResponse(WebResponse originalResponse) {
        return new BufferedWebResponse(originalResponse);
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        tag.put("xmlns:wicket", "http://wicket.apache.org");
    }

    public void beforeRender(Component component) {
        super.beforeRender(component);
        RequestCycle requestCycle = RequestCycle.get();
        this.webResponse = (WebResponse)requestCycle.getResponse();
        BufferedWebResponse response = this.newResponse(this.webResponse);
        if (response == null) {
            throw new IllegalStateException("newResponse() must not return null");
        }
        requestCycle.setResponse((Response)response);
    }

    public void afterRender(Component component) {
        RequestCycle requestCycle = RequestCycle.get();
        try {
            BufferedWebResponse response = (BufferedWebResponse)requestCycle.getResponse();
            CharSequence output = this.transform(component, response.getText());
            response.setText(output);
            response.writeTo(this.webResponse);
        }
        catch (Exception ex) {
            throw new WicketRuntimeException("Error while transforming the output: " + this, ex);
        }
        finally {
            requestCycle.setResponse((Response)this.webResponse);
        }
    }

    public void detach(Component component) {
        this.webResponse = null;
        super.detach(component);
    }

    public abstract CharSequence transform(Component var1, CharSequence var2) throws Exception;
}

