/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.string.Strings;

public final class WicketTagIdentifier
extends AbstractMarkupFilter {
    private static List<String> wellKnownTagNames;
    private final MarkupResourceStream markup;

    public WicketTagIdentifier(MarkupResourceStream markup) {
        this.markup = markup;
    }

    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        String namespace = this.markup.getWicketNamespace();
        String wicketIdValue = tag.getAttributes().getString(namespace + ":id");
        if (namespace.equalsIgnoreCase(tag.getNamespace())) {
            tag = new WicketTag(tag.getXmlTag());
            if (Strings.isEmpty((CharSequence)wicketIdValue)) {
                tag.setId("_wicket_" + tag.getName());
                tag.setAutoComponentTag(true);
                tag.setModified(true);
            }
            if (!this.isWellKnown(tag)) {
                throw new WicketParseException("Unknown tag name with Wicket namespace: '" + tag.getName() + "'. Might be you haven't installed the appropriate resolver?", tag);
            }
        }
        if (wicketIdValue != null) {
            if (wicketIdValue.trim().length() == 0) {
                throw new WicketParseException("The wicket:id attribute value must not be empty. May be unmatched quotes?!?", tag);
            }
            tag.setId(wicketIdValue);
        }
        return tag;
    }

    public static final void registerWellKnownTagName(String name) {
        if (wellKnownTagNames == null) {
            wellKnownTagNames = new ArrayList<String>();
        }
        if (!wellKnownTagNames.contains(name)) {
            wellKnownTagNames.add(name);
        }
    }

    private boolean isWellKnown(ComponentTag tag) {
        for (String name : wellKnownTagNames) {
            if (!tag.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

