/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;

public final class StyleAndScriptIdentifier
extends AbstractMarkupFilter {
    private boolean found;
    private final Markup markup;

    public StyleAndScriptIdentifier(Markup markup) {
        this.markup = markup;
    }

    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag.getNamespace() != null) {
            return tag;
        }
        if ("script".equalsIgnoreCase(tag.getName()) || "style".equalsIgnoreCase(tag.getName())) {
            if (tag.isOpen() && tag.getId() == null) {
                tag.setId("_ScriptStyle");
                tag.setModified(true);
            }
            tag.setFlag(32, true);
            tag.setUserData("STYLE_OR_SCRIPT", Boolean.TRUE);
        }
        return tag;
    }

    public void postProcess(Markup markup) {
        for (int i = 0; i < markup.size(); ++i) {
            String text;
            ComponentTag close;
            ComponentTag open;
            MarkupElement elem = markup.get(i);
            if (!(elem instanceof ComponentTag) || (open = (ComponentTag)elem).getUserData("STYLE_OR_SCRIPT") == null || !open.isOpen() || i + 2 >= markup.size()) continue;
            MarkupElement body = markup.get(i + 1);
            MarkupElement tag2 = markup.get(i + 2);
            if (!(body instanceof RawMarkup) || !(tag2 instanceof ComponentTag) || !(close = (ComponentTag)tag2).closes(open) || (text = body.toString().trim()).startsWith("<!--") || text.startsWith("<![CDATA[") || text.startsWith("/*<![CDATA[*/")) continue;
            text = "\n/*<![CDATA[*/\n" + body.toString() + "\n/*]]>*/\n";
            markup.replace(i + 1, new RawMarkup(text));
        }
    }
}

