/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.loader;

import java.io.IOException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MergedMarkup;
import org.apache.wicket.markup.TagUtils;
import org.apache.wicket.markup.loader.IMarkupLoader;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class InheritedMarkupMarkupLoader
implements IMarkupLoader {
    public final Markup loadMarkup(MarkupContainer container, MarkupResourceStream markupResourceStream, IMarkupLoader baseLoader, boolean enforceReload) throws IOException, ResourceStreamNotFoundException {
        Markup markup = baseLoader.loadMarkup(container, markupResourceStream, null, enforceReload);
        int extendIndex = this.requiresBaseMarkup(markup);
        if (extendIndex == -1) {
            return markup;
        }
        Markup baseMarkup = this.getBaseMarkup(container, markup, enforceReload);
        if (baseMarkup == null || baseMarkup == Markup.NO_MARKUP) {
            throw new MarkupNotFoundException("Base markup of inherited markup not found. Component class: " + markup.getMarkupResourceStream().getContainerInfo().getContainerClass().getName() + ". Enable debug messages for org.apache.wicket.util.resource.locator.ResourceStreamLocator to get a list of all filenames tried.");
        }
        return new MergedMarkup(markup, baseMarkup, extendIndex);
    }

    private Markup getBaseMarkup(MarkupContainer container, Markup markup, boolean enforceReload) {
        Class<? extends Component> location = markup.getMarkupResourceStream().getMarkupClass().getSuperclass();
        return MarkupFactory.get().getMarkup(container, location, enforceReload);
    }

    private int requiresBaseMarkup(IMarkupFragment markup) {
        for (int i = 0; i < markup.size(); ++i) {
            if (!TagUtils.isExtendTag(markup, i)) continue;
            return i;
        }
        return -1;
    }
}

