/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.panel.AssociatedMarkupSourcingStrategy;

public class PanelMarkupSourcingStrategy
extends AssociatedMarkupSourcingStrategy {
    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(component, markupStream, openTag);
        ((MarkupContainer)component).renderAssociatedMarkup("panel", "Markup for a panel component has to contain part '<wicket:panel>'");
    }

    public IMarkupFragment getMarkup(MarkupContainer parent, Component child) {
        IMarkupFragment markup = parent.getAssociatedMarkup();
        if (markup == null) {
            throw new MarkupNotFoundException("Failed to find markup file associated. " + parent.getClass().getSimpleName() + ": " + parent.toString());
        }
        IMarkupFragment panelMarkup = PanelMarkupSourcingStrategy.findPanelTag(markup);
        if (panelMarkup == null) {
            throw new MarkupNotFoundException("Expected to find <wicket:panel> in associated markup file. Markup: " + markup.toString());
        }
        if (child == null) {
            return panelMarkup;
        }
        markup = panelMarkup.find(child.getId());
        if (markup != null) {
            return markup;
        }
        return this.findMarkupInAssociatedFileHeader(parent, child);
    }

    private static final IMarkupFragment findPanelTag(IMarkupFragment markup) {
        MarkupStream stream = new MarkupStream(markup);
        while (stream.skipUntil(ComponentTag.class)) {
            ComponentTag tag = stream.getTag();
            if (tag.isOpen() || tag.isOpenClose()) {
                WicketTag wtag;
                if (tag instanceof WicketTag && (wtag = (WicketTag)tag).isPanelTag()) {
                    return stream.getMarkupFragment();
                }
                stream.skipToMatchingCloseTag(tag);
            }
            stream.next();
        }
        return null;
    }
}

