/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.parser.XmlTag;

public abstract class AbstractMarkupSourcingStrategy
implements IMarkupSourcingStrategy {
    public void onComponentTag(Component component, ComponentTag tag) {
        if (tag.isOpenClose()) {
            tag.setType(XmlTag.TagType.OPEN);
        }
    }

    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        if (markupStream.getPreviousTag().isOpen()) {
            markupStream.skipRawMarkup();
            if (!markupStream.get().closes(openTag)) {
                throw new MarkupException(markupStream, "Close tag not found for tag: " + openTag.toString() + ". Component: " + component.toString());
            }
        }
    }

    public abstract IMarkupFragment getMarkup(MarkupContainer var1, Component var2);

    public void renderHead(Component component, HtmlHeaderContainer container) {
    }
}

