/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.io.File;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.UrlEncoder;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadLink
extends Link<File> {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private boolean deleteAfter;

    public DownloadLink(String id, File file) {
        super(id);
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.setDefaultModel(new Model<File>(file));
    }

    public DownloadLink(String id, IModel<File> model) {
        super(id, model);
    }

    public DownloadLink(String id, IModel<File> model, String fileName) {
        super(id, model);
        this.fileName = fileName;
    }

    public DownloadLink(String id, File file, String fileName) {
        super(id);
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (Strings.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("fileName cannot be an empty string");
        }
        this.setDefaultModel(new Model<File>(file));
        this.fileName = fileName;
    }

    @Override
    public void onClick() {
        final File file = (File)this.getModelObject();
        if (file == null) {
            throw new IllegalStateException(this.getClass().getName() + " failed to retrieve a File object from model");
        }
        String fn = UrlEncoder.QUERY_INSTANCE.encode(this.fileName != null ? this.fileName : file.getName(), this.getRequest().getCharset());
        FileResourceStream resourceStream = new FileResourceStream(new org.apache.wicket.util.file.File(file));
        this.getRequestCycle().scheduleRequestHandlerAfterCurrent(new ResourceStreamRequestHandler((IResourceStream)resourceStream){

            public void respond(IRequestCycle requestCycle) {
                super.respond(requestCycle);
                if (DownloadLink.this.deleteAfter) {
                    Files.remove((File)file);
                }
            }
        }.setFileName(fn).setContentDisposition(ContentDisposition.ATTACHMENT));
    }

    public final DownloadLink setDeleteAfterDownload(boolean deleteAfter) {
        this.deleteAfter = deleteAfter;
        return this;
    }
}

