/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.time.Time;

public abstract class RenderedDynamicImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private int height = 100;
    private transient SoftReference<byte[]> imageData;
    private int type = 1;
    private int width = 100;

    public RenderedDynamicImageResource(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public RenderedDynamicImageResource(int width, int height, String format) {
        super(format);
        this.width = width;
        this.height = height;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized int getType() {
        return this.type;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized void invalidate() {
        this.imageData = null;
    }

    public synchronized void setHeight(int height) {
        this.height = height;
        this.invalidate();
    }

    public synchronized void setType(int type) {
        this.type = type;
        this.invalidate();
    }

    public synchronized void setWidth(int width) {
        this.width = width;
        this.invalidate();
    }

    protected byte[] getImageData(IResource.Attributes attributes) {
        byte[] data = null;
        if (this.imageData != null) {
            data = this.imageData.get();
        }
        if (data == null) {
            data = this.render();
            this.imageData = new SoftReference<byte[]>(data);
            this.setLastModifiedTime(Time.now());
        }
        return data;
    }

    protected byte[] render() {
        BufferedImage image;
        while (!this.render((Graphics2D)(image = new BufferedImage(this.getWidth(), this.getHeight(), this.getType())).getGraphics())) {
        }
        return this.toImageData(image);
    }

    protected abstract boolean render(Graphics2D var1);
}

