/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMultipleChoice<T>
extends AbstractChoice<Collection<T>, T> {
    private static final long serialVersionUID = 1L;
    static MetaDataKey<Boolean> RETAIN_DISABLED_META_KEY = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };
    private static final Logger log = LoggerFactory.getLogger(ListMultipleChoice.class);
    private static int defaultMaxRows = 8;
    private int maxRows = defaultMaxRows;

    protected static int getDefaultMaxRows() {
        return defaultMaxRows;
    }

    protected static void setDefaultMaxRows(int defaultMaxRows) {
        ListMultipleChoice.defaultMaxRows = defaultMaxRows;
    }

    public ListMultipleChoice(String id) {
        super(id);
    }

    public ListMultipleChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public ListMultipleChoice(String id, List<? extends T> choices, int maxRows) {
        super(id, choices);
        this.maxRows = maxRows;
    }

    public ListMultipleChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> object, List<? extends T> choices) {
        super(id, object, choices);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> object, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, object, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public ListMultipleChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public ListMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public final ListMultipleChoice<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public final String getModelValue() {
        Collection selectedValues = (Collection)this.getModelObject();
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        if (selectedValues != null) {
            List choices = this.getChoices();
            for (Object object : selectedValues) {
                int index = choices.indexOf(object);
                buffer.append(this.getChoiceRenderer().getIdValue(object, index));
                buffer.append(VALUE_SEPARATOR);
            }
        }
        return buffer.toString();
    }

    @Override
    protected final boolean isSelected(T choice, int index, String selected) {
        if (selected != null) {
            StringTokenizer tokenizer = new StringTokenizer(selected, VALUE_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken();
                if (!id.equals(this.getChoiceRenderer().getIdValue(choice, index))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("multiple", "multiple");
        if (!tag.getAttributes().containsKey((Object)"size")) {
            tag.put("size", Math.min(this.maxRows, this.getChoices().size()));
        }
    }

    @Override
    protected Collection<T> convertValue(String[] ids) throws ConversionException {
        if (ids != null && ids.length > 0 && !Strings.isEmpty((CharSequence)ids[0])) {
            return this.convertChoiceIdsToChoices(ids);
        }
        ArrayList result = new ArrayList();
        this.addRetainedDisabled(result);
        return result;
    }

    protected List<T> convertChoiceIdsToChoices(String[] ids) {
        ArrayList selectedValues = new ArrayList();
        if (ids != null && ids.length > 0 && !Strings.isEmpty((CharSequence)ids[0])) {
            List choices = this.getChoices();
            block0: for (String id : ids) {
                for (int index = 0; index < choices.size(); ++index) {
                    Object choice = choices.get(index);
                    if (!this.getChoiceRenderer().getIdValue(choice, index).equals(id)) continue;
                    selectedValues.add(choice);
                    continue block0;
                }
            }
        }
        this.addRetainedDisabled(selectedValues);
        return selectedValues;
    }

    private void addRetainedDisabled(ArrayList<T> selectedValues) {
        if (this.isRetainDisabledSelected()) {
            Collection unchangedModel = (Collection)this.getModelObject();
            StringBuilder builder = new StringBuilder();
            for (Object t : unchangedModel) {
                builder.append(t);
                builder.append(";");
            }
            String selected = builder.toString();
            List choices = this.getChoices();
            for (int i = 0; i < choices.size(); ++i) {
                Object choice = choices.get(i);
                if (!this.isDisabled(choice, i, selected) || !unchangedModel.contains(choice) || selectedValues.contains(choice)) continue;
                selectedValues.add(choice);
            }
        }
    }

    @Override
    public void updateModel() {
        ArrayList selectedValues = (ArrayList)this.getModelObject();
        if (selectedValues != null) {
            if (this.getDefaultModelObject() != selectedValues) {
                throw new WicketRuntimeException("Updating a ListMultipleChoice works by modifying the underlying model object in-place, so please make sure that getObject() always returns the same Collection instance!");
            }
            this.modelChanging();
            selectedValues.clear();
            Collection converted = (Collection)this.getConvertedInput();
            if (converted != null) {
                selectedValues.addAll(converted);
            }
            this.modelChanged();
            try {
                this.getModel().setObject(selectedValues);
            }
            catch (Exception e) {
                log.info("no setter for the property attached to " + this);
            }
        } else {
            selectedValues = new ArrayList((Collection)this.getConvertedInput());
            this.setDefaultModelObject(selectedValues);
        }
    }

    public boolean isRetainDisabledSelected() {
        Boolean flag = this.getMetaData(RETAIN_DISABLED_META_KEY);
        return flag != null && flag != false;
    }

    public ListMultipleChoice<T> setRetainDisabledSelected(boolean retain) {
        this.setMetaData(RETAIN_DISABLED_META_KEY, retain ? Boolean.valueOf(true) : null);
        return this;
    }
}

