/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxMultipleChoice<T>
extends ListMultipleChoice<T> {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "<br/>\n";

    public CheckBoxMultipleChoice(String id) {
        super(id);
    }

    public CheckBoxMultipleChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public CheckBoxMultipleChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public CheckBoxMultipleChoice(String id, IModel<? extends Collection<T>> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public final CheckBoxMultipleChoice<T> setPrefix(String prefix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange();
        }
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public final CheckBoxMultipleChoice<T> setSuffix(String suffix) {
        Page page = this.findPage();
        if (page != null) {
            this.addStateChange();
        }
        this.suffix = suffix;
        return this;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("multiple");
        tag.remove("size");
        tag.remove("disabled");
        tag.remove("name");
    }

    @Override
    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer(70 * (choices.size() + 1));
        String selected = this.getValue();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            this.appendOptionHtml(buffer, (T)choice, index, selected);
        }
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)buffer);
    }

    @Override
    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
        Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
        String label = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter<?> converter = this.getConverter(objectClass);
            label = converter.convertToString(displayValue, this.getLocale());
        } else if (displayValue != null) {
            label = displayValue.toString();
        }
        if (label != null) {
            buffer.append(this.getPrefix());
            String id = this.getChoiceRenderer().getIdValue(choice, index);
            String idAttr = this.getCheckBoxMarkupId(id);
            buffer.append("<input name=\"");
            buffer.append(this.getInputName());
            buffer.append("\"");
            buffer.append(" type=\"checkbox\"");
            if (this.isSelected(choice, index, selected)) {
                buffer.append(" checked=\"checked\"");
            }
            if (this.isDisabled(choice, index, selected)) {
                buffer.append(" disabled=\"disabled\"");
            }
            buffer.append(" value=\"");
            buffer.append(id);
            buffer.append("\" id=\"");
            buffer.append(idAttr);
            buffer.append("\"/>");
            String display = label;
            if (this.localizeDisplayValues()) {
                display = this.getLocalizer().getString(label, (Component)this, label);
            }
            CharSequence escaped = this.getEscapeModelStrings() ? Strings.escapeMarkup((CharSequence)display) : display;
            buffer.append("<label for=\"");
            buffer.append(idAttr);
            buffer.append("\">").append((Object)escaped).append("</label>");
            buffer.append(this.getSuffix());
        }
    }

    protected String getCheckBoxMarkupId(String id) {
        return this.getMarkupId() + "-" + this.getInputName() + "_" + id;
    }
}

