/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBox
extends FormComponent<Boolean>
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public CheckBox(String id) {
        this(id, (IModel<Boolean>)null);
    }

    public CheckBox(String id, IModel<Boolean> model) {
        super(id, model);
        this.setType(Boolean.class);
    }

    @Override
    public void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged((Boolean)this.getModelObject());
    }

    protected void onSelectionChanged(Boolean newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    @Override
    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
        String value = this.getValue();
        IConverter<Boolean> converter = this.getConverter(Boolean.class);
        Boolean checked = (Boolean)converter.convertToObject(value, this.getLocale());
        if (Boolean.TRUE.equals(checked)) {
            tag.put("checked", "checked");
        } else {
            tag.remove("checked");
        }
        tag.remove("value");
        if (this.wantOnSelectionChangedNotifications()) {
            CharSequence url = this.urlFor(IOnChangeListener.INTERFACE);
            Form form = this.findParent(Form.class);
            if (form != null) {
                tag.put("onclick", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onclick", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&" : "?") + this.getInputName() + "=' + this.checked;");
            }
        }
        super.onComponentTag(tag);
    }

    @Override
    public final <C> IConverter<C> getConverter(Class<C> type) {
        if (Boolean.class.equals(type)) {
            IConverter converter = CheckBoxConverter.INSTANCE;
            return converter;
        }
        return super.getConverter(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckBoxConverter
    implements IConverter<Boolean> {
        private static final long serialVersionUID = 1L;
        private static final IConverter<Boolean> INSTANCE = new CheckBoxConverter();

        private CheckBoxConverter() {
        }

        public Boolean convertToObject(String value, Locale locale) {
            if ("on".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String convertToString(Boolean value, Locale locale) {
            return value.toString();
        }
    }
}

