/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingleSelectChoice<T>
extends AbstractChoice<T, T> {
    private static final long serialVersionUID = 1L;
    private static final String CHOOSE_ONE = "Choose One";
    protected static final Object NO_SELECTION_VALUE = "-1";
    private static final String EMPTY_STRING = "";
    private boolean nullValid = false;

    public AbstractSingleSelectChoice(String id) {
        super(id);
    }

    public AbstractSingleSelectChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public AbstractSingleSelectChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public AbstractSingleSelectChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public AbstractSingleSelectChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    protected Object getNoSelectionValue() {
        return NO_SELECTION_VALUE;
    }

    @Override
    public String getModelValue() {
        Object object = this.getModelObject();
        if (object != null) {
            int index = this.getChoices().indexOf(object);
            return this.getChoiceRenderer().getIdValue(object, index);
        }
        Object noSelectionValue = this.getNoSelectionValue();
        return noSelectionValue != null ? noSelectionValue.toString() : null;
    }

    public boolean isNullValid() {
        return this.nullValid;
    }

    public AbstractSingleSelectChoice<T> setNullValid(boolean nullValid) {
        this.nullValid = nullValid;
        return this;
    }

    @Override
    protected final T convertValue(String[] value) {
        String tmp = value != null && value.length > 0 ? value[0] : null;
        return this.convertChoiceIdToChoice(tmp);
    }

    protected T convertChoiceIdToChoice(String id) {
        List choices = this.getChoices();
        IChoiceRenderer renderer = this.getChoiceRenderer();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            if (!renderer.getIdValue(choice, index).equals(id)) continue;
            return (T)choice;
        }
        return null;
    }

    @Override
    protected CharSequence getDefaultChoice(Object selected) {
        Object noSelectionValue = this.getNoSelectionValue();
        if (this.isNullValid()) {
            String option = this.getLocalizer().getStringIgnoreSettings(this.getNullValidKey(), this, null, null);
            if (Strings.isEmpty((CharSequence)option)) {
                option = this.getLocalizer().getString("nullValid", (Component)this, EMPTY_STRING);
            }
            AppendingStringBuffer buffer = new AppendingStringBuffer(64 + option.length());
            buffer.append("\n<option");
            if (selected == noSelectionValue) {
                buffer.append(" selected=\"selected\"");
            }
            buffer.append(" value=\"" + noSelectionValue + "\">").append(option).append("</option>");
            return buffer;
        }
        if (selected == null || selected.equals(noSelectionValue) || selected.equals(EMPTY_STRING)) {
            String option = this.getLocalizer().getStringIgnoreSettings(this.getNullKey(), this, null, null);
            if (Strings.isEmpty((CharSequence)option)) {
                option = this.getLocalizer().getString("null", (Component)this, CHOOSE_ONE);
            }
            return "\n<option selected=\"selected\" value=\"" + noSelectionValue + "\">" + option + "</option>";
        }
        return EMPTY_STRING;
    }

    protected String getNullValidKey() {
        return this.getId() + ".nullValid";
    }

    protected String getNullKey() {
        return this.getId() + ".null";
    }

    @Override
    protected boolean isSelected(T object, int index, String selected) {
        return selected != null && selected.equals(this.getChoiceRenderer().getIdValue(object, index));
    }
}

