/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.renderStrategy.AbstractHeaderRenderStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPage
extends Page {
    private static final Logger log = LoggerFactory.getLogger(WebPage.class);
    private static final long serialVersionUID = 1L;

    protected WebPage() {
        this.commonInit();
    }

    protected WebPage(IModel<?> model) {
        super(model);
        this.commonInit();
    }

    protected WebPage(PageParameters parameters) {
        super(parameters);
        this.commonInit();
    }

    @Override
    public MarkupType getMarkupType() {
        return MarkupType.HTML_MARKUP_TYPE;
    }

    private void commonInit() {
    }

    @Override
    protected void onRender() {
        this.configureResponse((WebResponse)RequestCycle.get().getResponse());
        this.renderXmlDecl();
        super.onRender();
    }

    protected void renderXmlDecl() {
        WebApplication.get().renderXmlDecl(this, false);
    }

    protected void configureResponse(WebResponse response) {
        RequestCycle cycle = this.getRequestCycle();
        WebApplication application = WebApplication.get();
        this.setHeaders(response);
        String encoding = application.getRequestCycleSettings().getResponseRequestEncoding();
        boolean validEncoding = !Strings.isEmpty((CharSequence)encoding);
        String contentType = validEncoding ? this.getMarkupType().getMimeType() + "; charset=" + encoding : this.getMarkupType().getMimeType();
        response.setContentType(contentType);
    }

    protected void setHeaders(WebResponse response) {
        response.disableCaching();
    }

    @Override
    protected void onAfterRender() {
        IPageRequestHandler h;
        IRequestHandler activeHandler;
        super.onAfterRender();
        if (this.getApplication().usesDevelopmentConfig() && (activeHandler = this.getRequestCycle().getActiveRequestHandler()) instanceof IPageRequestHandler && (h = (IPageRequestHandler)activeHandler).getPage() == this) {
            this.validateHeaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateHeaders() {
        HtmlHeaderContainer header = this.visitChildren(new IVisitor<Component, HtmlHeaderContainer>(){

            public void component(Component component, IVisit<HtmlHeaderContainer> visit) {
                if (component instanceof HtmlHeaderContainer) {
                    visit.stop((Object)((HtmlHeaderContainer)component));
                } else if (!(component instanceof TransparentWebMarkupContainer)) {
                    visit.dontGoDeeper();
                }
            }
        });
        if (header == null) {
            header = new HtmlHeaderContainer("_header_");
            this.add(header);
            Response orgResponse = this.getRequestCycle().getResponse();
            try {
                StringResponse response = new StringResponse();
                this.getRequestCycle().setResponse(response);
                AbstractHeaderRenderStrategy.get().renderHeader(header, this.getPage());
                response.close();
                if (response.getBuffer().length() > 0) {
                    log.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    log.error("You probably forgot to add a <body> or <head> tag to your markup since no Header Container was \nfound but components were found which want to write to the <head> section.\n" + response.getBuffer());
                    log.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                }
            }
            catch (Exception e) {
                log.error("header/body check throws exception", (Throwable)e);
            }
            finally {
                this.remove(header);
                this.getRequestCycle().setResponse(orgResponse);
            }
        }
    }

    protected final BookmarkablePageLink<Void> homePageLink(String id) {
        return new BookmarkablePageLink<Void>(id, this.getApplication().getHomePage());
    }
}

