/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.Iterator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupFragment
implements IMarkupFragment {
    private final IMarkupFragment markup;
    private final int startIndex;
    private final int size;

    public MarkupFragment(IMarkupFragment markup, int startIndex) {
        int endIndex;
        Args.notNull((Object)markup, (String)"markup");
        if (startIndex < 0) {
            throw new IllegalArgumentException("Parameter 'startIndex' must not be < 0");
        }
        if (startIndex >= markup.size()) {
            throw new IllegalArgumentException("Parameter 'startIndex' must not be >= markup.size()");
        }
        this.markup = markup;
        this.startIndex = startIndex;
        MarkupElement startElem = markup.get(startIndex);
        if (!(startElem instanceof ComponentTag)) {
            throw new IllegalArgumentException("Parameter 'index' does not point to a Wicket open tag");
        }
        ComponentTag startTag = (ComponentTag)startElem;
        if (startTag.isOpenClose()) {
            endIndex = startIndex;
        } else if (startTag.hasNoCloseTag()) {
            for (endIndex = startIndex + 1; endIndex < markup.size(); ++endIndex) {
                MarkupElement elem = markup.get(endIndex);
                if (!(elem instanceof ComponentTag)) continue;
                --endIndex;
                break;
            }
        } else {
            ComponentTag tag;
            MarkupElement elem;
            for (endIndex = startIndex + 1; !(endIndex >= markup.size() || (elem = markup.get(endIndex)) instanceof ComponentTag && (tag = (ComponentTag)elem).closes(startTag)); ++endIndex) {
            }
        }
        if (endIndex >= markup.size()) {
            throw new MarkupException("Unable to find close tag for: '" + startTag.toString() + "' in " + this.getRootMarkup().getMarkupResourceStream().toString());
        }
        this.size = endIndex - startIndex + 1;
    }

    @Override
    public final MarkupElement get(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Parameter 'index' is out of range: 0 <= " + index + " <= " + this.size);
        }
        return this.markup.get(this.startIndex + index);
    }

    @Override
    public final IMarkupFragment find(String id) {
        Args.notEmpty((CharSequence)id, (String)"id");
        MarkupStream stream = new MarkupStream(this);
        stream.setCurrentIndex(1);
        while (stream.hasMore()) {
            ComponentTag tag;
            MarkupElement elem = stream.get();
            if (elem instanceof ComponentTag && ((tag = stream.getTag()).isOpen() || tag.isOpenClose())) {
                if (tag.getId().equals(id)) {
                    return stream.getMarkupFragment();
                }
                if (tag.isOpen() && !tag.hasNoCloseTag() && !tag.isAutoComponentTag()) {
                    stream.skipToMatchingCloseTag(tag);
                }
            }
            stream.next();
        }
        return null;
    }

    @Override
    public final MarkupResourceStream getMarkupResourceStream() {
        return this.markup.getMarkupResourceStream();
    }

    @Override
    public final int size() {
        return this.size;
    }

    private final IMarkupFragment getParentMarkup() {
        return this.markup;
    }

    public final Markup getRootMarkup() {
        IMarkupFragment markup = this.getParentMarkup();
        while (markup != null && !(markup instanceof Markup)) {
            markup = ((MarkupFragment)markup).getParentMarkup();
        }
        return (Markup)markup;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean markupOnly) {
        AppendingStringBuffer buf = new AppendingStringBuffer(400);
        if (!markupOnly) {
            buf.append(this.getRootMarkup().getMarkupResourceStream().toString());
            buf.append("\n");
        }
        for (int i = 0; i < this.size(); ++i) {
            buf.append((Object)this.get(i));
        }
        return buf.toString();
    }

    @Override
    public Iterator<MarkupElement> iterator() {
        return this.getRootMarkup().iterator(this.startIndex, this.size);
    }
}

