/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultClassResolver
implements IClassResolver {
    private final ConcurrentHashMap<String, WeakReference<Class<?>>> classes = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> resolveClass(String classname) throws ClassNotFoundException {
        Class<Comparable<Byte>> clazz = null;
        WeakReference<Class<?>> ref = this.classes.get(classname);
        if (ref != null) {
            clazz = (Class<Byte>)ref.get();
        }
        if (clazz == null) {
            if (classname.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (classname.equals("short")) {
                clazz = Short.TYPE;
            } else if (classname.equals("int")) {
                clazz = Integer.TYPE;
            } else if (classname.equals("long")) {
                clazz = Long.TYPE;
            } else if (classname.equals("float")) {
                clazz = Float.TYPE;
            } else if (classname.equals("double")) {
                clazz = Double.TYPE;
            } else if (classname.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (classname.equals("char")) {
                clazz = Character.TYPE;
            } else {
                ConcurrentHashMap<String, WeakReference<Class<?>>> concurrentHashMap = this.classes;
                synchronized (concurrentHashMap) {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = DefaultClassResolver.class.getClassLoader();
                    }
                    if ((clazz = Class.forName(classname, false, loader)) == null) {
                        throw new ClassNotFoundException(classname);
                    }
                }
                this.classes.put(classname, new WeakReference<Class<Byte>>(clazz));
            }
        }
        return clazz;
    }

    @Override
    public Iterator<URL> getResources(String name) {
        HashSet<URL> loadedFiles = new HashSet<URL>();
        try {
            Enumeration<URL> resources = Application.class.getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            resources = Application.get().getClass().getClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
            resources = Thread.currentThread().getContextClassLoader().getResources(name);
            this.loadResources(resources, loadedFiles);
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
        return loadedFiles.iterator();
    }

    private void loadResources(Enumeration<URL> resources, Set<URL> loadedFiles) {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (loadedFiles.contains(url)) continue;
                loadedFiles.add(url);
            }
        }
    }
}

