/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxSubmitLink
extends AbstractSubmitLink {
    private static final long serialVersionUID = 1L;

    public AjaxSubmitLink(String id) {
        this(id, (Form<?>)null);
    }

    public AjaxSubmitLink(String id, Form<?> form) {
        super(id, form);
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onSubmit(target, this.getForm());
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onError(target, this.getForm());
            }

            protected CharSequence getEventHandler() {
                return new AppendingStringBuffer(super.getEventHandler()).append("; return false;");
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxSubmitLink.this.getAjaxCallDecorator();
            }

            protected void onComponentTag(ComponentTag tag) {
                if (AjaxSubmitLink.this.isLinkEnabled()) {
                    super.onComponentTag(tag);
                }
            }

            public boolean getDefaultProcessing() {
                return AjaxSubmitLink.this.getDefaultFormProcessing();
            }
        });
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isLinkEnabled()) {
            if (tag.getName().toLowerCase().equals("a")) {
                tag.put("href", "#");
            }
        } else {
            this.disableLink(tag);
        }
    }

    @Override
    public final void onSubmit() {
    }

    @Override
    public final void onError() {
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form<?> var2);

    protected abstract void onError(AjaxRequestTarget var1, Form<?> var2);
}

