/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxFallbackButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form<?> mForm;

    public AjaxFallbackButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxFallbackButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.mForm = form;
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onSubmit(target, AjaxFallbackButton.this.getForm());
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onError(target, AjaxFallbackButton.this.getForm());
            }

            protected CharSequence getEventHandler() {
                return new AppendingStringBuffer(super.getEventHandler()).append("; return false;");
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxFallbackButton.this.getAjaxCallDecorator();
            }

            public boolean getDefaultProcessing() {
                return AjaxFallbackButton.this.getDefaultFormProcessing();
            }
        });
    }

    protected abstract void onError(AjaxRequestTarget var1, Form<?> var2);

    @Override
    public final void onSubmit() {
        if (AjaxRequestTarget.get() == null) {
            this.onSubmit(null, this.getForm());
        }
    }

    @Override
    public Form<?> getForm() {
        return this.mForm == null ? super.getForm() : this.mForm;
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form<?> var2);

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected final boolean isButtonEnabled() {
        return this.isEnabledInHierarchy();
    }
}

