/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form<?> form;

    public AjaxButton(String id) {
        this(id, null, null);
    }

    public AjaxButton(String id, IModel<String> model) {
        this(id, model, null);
    }

    public AjaxButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.form = form;
        this.add(new AjaxFormSubmitBehavior(form, "onclick"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                AjaxButton.this.onSubmit(target, AjaxButton.this.getForm());
            }

            protected void onError(AjaxRequestTarget target) {
                AjaxButton.this.onError(target, AjaxButton.this.getForm());
            }

            protected CharSequence getEventHandler() {
                String script = AjaxButton.this.getOnClickScript();
                AppendingStringBuffer handler = new AppendingStringBuffer();
                if (!Strings.isEmpty((CharSequence)script)) {
                    handler.append(script).append(";");
                }
                handler.append((Object)super.getEventHandler());
                handler.append("; return false;");
                return handler;
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AjaxButton.this.getAjaxCallDecorator();
            }

            public boolean getDefaultProcessing() {
                return AjaxButton.this.getDefaultFormProcessing();
            }
        });
    }

    @Override
    public Form<?> getForm() {
        if (this.form != null) {
            return this.form;
        }
        return super.getForm();
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form<?> var2);

    protected abstract void onError(AjaxRequestTarget var1, Form<?> var2);
}

