/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.html.IComponentAwareHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public abstract class AbstractDefaultAjaxBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference INDICATOR = new PackageResourceReference(AbstractDefaultAjaxBehavior.class, "indicator.gif");
    private static final ResourceReference JAVASCRIPT_DEBUG = new JavaScriptResourceReference(AbstractDefaultAjaxBehavior.class, "wicket-ajax-debug.js");

    protected void onBind() {
        this.getComponent().setOutputMarkupId(true);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderJavaScriptReference(WicketEventReference.INSTANCE);
        response.renderJavaScriptReference(WicketAjaxReference.INSTANCE);
        IDebugSettings debugSettings = Application.get().getDebugSettings();
        if (debugSettings.isAjaxDebugModeEnabled()) {
            response.renderJavaScriptReference(JAVASCRIPT_DEBUG);
            response.renderJavaScript("wicketAjaxDebugEnable=true;", "wicket-ajax-debug-enable");
        }
        Url baseUrl = RequestCycle.get().getUrlRenderer().getBaseUrl();
        CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
        response.renderJavaScript("Wicket.Ajax.baseUrl=\"" + ajaxBaseUrl + "\";", "wicket-ajax-base-url");
        IAjaxCallDecorator ajaxCallDecorator = this.getAjaxCallDecorator();
        if (ajaxCallDecorator instanceof IComponentAwareHeaderContributor) {
            IComponentAwareHeaderContributor contributor = (IComponentAwareHeaderContributor)((Object)ajaxCallDecorator);
            contributor.renderHead(component, response);
        }
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    protected CharSequence getCallbackScript() {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "'");
    }

    protected CharSequence getPreconditionScript() {
        if (this.getComponent() instanceof Page) {
            return "return true;";
        }
        return "return Wicket.$('" + this.getComponent().getMarkupId() + "') != null;";
    }

    protected CharSequence getFailureScript() {
        return null;
    }

    protected CharSequence getSuccessScript() {
        return null;
    }

    protected CharSequence generateCallbackScript(CharSequence partialCall) {
        String channel;
        CharSequence failure;
        CharSequence onSuccessScript = this.getSuccessScript();
        CharSequence onFailureScript = this.getFailureScript();
        CharSequence precondition = this.getPreconditionScript();
        IAjaxCallDecorator decorator = this.getAjaxCallDecorator();
        String indicatorId = this.findIndicatorId();
        CharSequence success = onSuccessScript == null ? "" : onSuccessScript;
        CharSequence charSequence = failure = onFailureScript == null ? "" : onFailureScript;
        if (decorator != null) {
            success = decorator.decorateOnSuccessScript(this.getComponent(), success);
        }
        if (!Strings.isEmpty((CharSequence)indicatorId)) {
            String hide = ";Wicket.hideIncrementally('" + indicatorId + "');";
            success = success + hide;
            failure = failure + hide;
        }
        if (decorator != null) {
            failure = decorator.decorateOnFailureScript(this.getComponent(), failure);
        }
        AppendingStringBuffer buff = new AppendingStringBuffer(256);
        buff.append("var ").append("wcall").append("=");
        buff.append((Object)partialCall);
        buff.append(",function() { ").append((Object)success).append("}.bind(this)");
        buff.append(",function() { ").append((Object)failure).append("}.bind(this)");
        if (precondition != null) {
            buff.append(", function() {");
            buff.append((Object)precondition);
            buff.append("}.bind(this)");
        }
        if ((channel = this.getChannelName()) != null) {
            if (precondition == null) {
                buff.append(", null");
            }
            buff.append(", '");
            buff.append(channel);
            buff.append("'");
        }
        buff.append(");");
        Object call = buff;
        if (!Strings.isEmpty((CharSequence)indicatorId)) {
            AppendingStringBuffer indicatorWithPrecondition = new AppendingStringBuffer((CharSequence)"if (");
            if (precondition != null) {
                indicatorWithPrecondition.append("function(){").append((Object)precondition).append("}.bind(this)()");
            } else {
                indicatorWithPrecondition.append("true");
            }
            indicatorWithPrecondition.append(") { Wicket.showIncrementally('").append(indicatorId).append("');}").append(call);
            call = indicatorWithPrecondition;
        }
        if (decorator != null) {
            call = decorator.decorateScript(this.getComponent(), (CharSequence)call);
        }
        return call;
    }

    protected String getChannelName() {
        return null;
    }

    protected String findIndicatorId() {
        if (this.getComponent() instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this.getComponent())).getAjaxIndicatorMarkupId();
        }
        if (this instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this)).getAjaxIndicatorMarkupId();
        }
        for (MarkupContainer parent = this.getComponent().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof IAjaxIndicatorAware)) continue;
            return ((IAjaxIndicatorAware)((Object)parent)).getAjaxIndicatorMarkupId();
        }
        return null;
    }

    public final void onRequest() {
        WebApplication app = (WebApplication)this.getComponent().getApplication();
        AjaxRequestTarget target = app.newAjaxRequestTarget(this.getComponent().getPage());
        RequestCycle requestCycle = RequestCycle.get();
        requestCycle.scheduleRequestHandlerAfterCurrent(target);
        this.respond(target);
    }

    protected abstract void respond(AjaxRequestTarget var1);

    public static CharSequence throttleScript(CharSequence script, String throttleId, Duration throttleDelay) {
        Args.notEmpty((CharSequence)script, (String)"script");
        Args.notEmpty((CharSequence)throttleId, (String)"throttleId");
        Args.notNull((Object)throttleDelay, (String)"throttleDelay");
        return new AppendingStringBuffer((CharSequence)"wicketThrottler.throttle( '").append(throttleId).append("', ").append(throttleDelay.getMilliseconds()).append(", function() { ").append((Object)script).append("}.bind(this));");
    }
}

