/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.PageAccessSynchronizer;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.LazyInitializer;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.lang.WicketObjects;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session
implements IClusterable,
IEventSink {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    public static final String SESSION_ATTRIBUTE_NAME = "session";
    private int sequence = 1;
    private int pageId = 0;
    private final IProvider<PageAccessSynchronizer> pageAccessSynchronizer;
    protected ClientInfo clientInfo;
    private transient boolean dirty = false;
    private final FeedbackMessages feedbackMessages = new FeedbackMessages();
    private String id = null;
    private Locale locale;
    private MetaDataEntry<?>[] metaData;
    private transient boolean sessionInvalidated = false;
    private transient ISessionStore sessionStore;
    private String style;
    private transient Map<String, Serializable> temporarySessionAttributes;

    public static boolean exists() {
        return ThreadContext.getSession() != null;
    }

    public static Session get() {
        Session session = ThreadContext.getSession();
        if (session != null) {
            return session;
        }
        return Application.get().fetchCreateAndSetSession(RequestCycle.get());
    }

    public Session(Request request) {
        this.locale = request.getLocale();
        if (this.locale == null) {
            throw new IllegalStateException("Request#getLocale() cannot return null, request has to have a locale set on it");
        }
        this.pageAccessSynchronizer = new PageAccessSynchronizerProvider();
    }

    public final void bind() {
        Request request;
        if (RequestCycle.get() == null) {
            return;
        }
        ISessionStore store = this.getSessionStore();
        if (store.lookup(request = RequestCycle.get().getRequest()) == null) {
            this.id = store.getSessionId(request, true);
            store.bind(request, this);
            if (this.temporarySessionAttributes != null) {
                for (Map.Entry<String, Serializable> entry : this.temporarySessionAttributes.entrySet()) {
                    store.setAttribute(request, String.valueOf(entry.getKey()), entry.getValue());
                }
                this.temporarySessionAttributes = null;
            }
        }
    }

    public abstract void cleanupFeedbackMessages();

    public final void clear() {
    }

    public final void error(Serializable message) {
        this.addFeedbackMessage(message, 400);
    }

    public final void fatal(Serializable message) {
        this.addFeedbackMessage(message, 500);
    }

    public final void debug(Serializable message) {
        this.addFeedbackMessage(message, 100);
    }

    public final Application getApplication() {
        return Application.get();
    }

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.getApplication().getSecuritySettings().getAuthorizationStrategy();
    }

    public final IClassResolver getClassResolver() {
        return this.getApplication().getApplicationSettings().getClassResolver();
    }

    public abstract ClientInfo getClientInfo();

    public final FeedbackMessages getFeedbackMessages() {
        return this.feedbackMessages;
    }

    public final String getId() {
        if (this.id == null) {
            RequestCycle requestCycle = RequestCycle.get();
            if (requestCycle != null) {
                this.id = this.getSessionStore().getSessionId(requestCycle.getRequest(), false);
            }
            if (this.id != null) {
                this.dirty();
            }
        }
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final synchronized <M extends Serializable> M getMetaData(MetaDataKey<M> key) {
        return (M)((Serializable)key.get(this.metaData));
    }

    protected boolean isCurrentRequestValid(RequestCycle lockedRequestCycle) {
        return true;
    }

    public IPageFactory getPageFactory() {
        return this.getApplication().getSessionSettings().getPageFactory();
    }

    public final long getSizeInBytes() {
        return WicketObjects.sizeof((Serializable)((Object)this));
    }

    public final String getStyle() {
        return this.style;
    }

    public final void info(Serializable message) {
        this.addFeedbackMessage(message, 200);
    }

    public final void success(Serializable message) {
        this.addFeedbackMessage(message, 250);
    }

    public void invalidate() {
        this.sessionInvalidated = true;
    }

    private void destroy() {
        if (this.sessionStore != null) {
            this.sessionStore.invalidate(RequestCycle.get().getRequest());
            this.sessionStore = null;
        }
    }

    public void invalidateNow() {
        this.invalidate();
        this.destroy();
    }

    public void replaceSession() {
        this.destroy();
        this.bind();
    }

    public final boolean isSessionInvalidated() {
        return this.sessionInvalidated;
    }

    public final boolean isTemporary() {
        return this.getId() == null;
    }

    public final void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        this.dirty();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Argument 'locale' must not be null");
        }
        if (!Objects.equal((Object)this.locale, (Object)locale)) {
            this.dirty();
        }
        this.locale = locale;
    }

    public final synchronized void setMetaData(MetaDataKey<?> key, Serializable object) {
        this.metaData = key.set(this.metaData, object);
        this.dirty();
    }

    public final Session setStyle(String style) {
        this.style = style;
        this.dirty();
        return this;
    }

    public final void warn(Serializable message) {
        this.addFeedbackMessage(message, 300);
    }

    private void addFeedbackMessage(Serializable message, int level) {
        this.getFeedbackMessages().add(null, message, level);
        this.dirty();
    }

    public void detach() {
        if (this.sessionInvalidated) {
            this.invalidateNow();
        }
    }

    public void internalDetach() {
        if (this.dirty) {
            Request request = RequestCycle.get().getRequest();
            this.getSessionStore().flushSession(request, this);
        }
        this.dirty = false;
    }

    public final void dirty() {
        this.dirty = true;
    }

    public final Serializable getAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return this.getSessionStore().getAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            return this.temporarySessionAttributes.get(name);
        }
        return null;
    }

    protected final List<String> getAttributeNames() {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                return Collections.unmodifiableList(this.getSessionStore().getAttributeNames(cycle.getRequest()));
            }
        } else if (this.temporarySessionAttributes != null) {
            return Collections.unmodifiableList(new ArrayList<String>(this.temporarySessionAttributes.keySet()));
        }
        return Collections.emptyList();
    }

    protected ISessionStore getSessionStore() {
        if (this.sessionStore == null) {
            this.sessionStore = this.getApplication().getSessionStore();
        }
        return this.sessionStore;
    }

    protected final void removeAttribute(String name) {
        if (!this.isTemporary()) {
            RequestCycle cycle = RequestCycle.get();
            if (cycle != null) {
                this.getSessionStore().removeAttribute(cycle.getRequest(), name);
            }
        } else if (this.temporarySessionAttributes != null) {
            this.temporarySessionAttributes.remove(name);
        }
    }

    public final void setAttribute(String name, Serializable value) {
        if (!this.isTemporary()) {
            String id;
            Serializable current;
            RequestCycle cycle = RequestCycle.get();
            if (cycle == null) {
                throw new IllegalStateException("Cannot set the attribute: no RequestCycle available.  If you get this error when using WicketTester.startPage(Page), make sure to call WicketTester.createRequestCycle() beforehand.");
            }
            ISessionStore store = this.getSessionStore();
            Request request = cycle.getRequest();
            if (value == this && (current = store.getAttribute(request, name)) == null && (id = store.getSessionId(request, false)) != null) {
                store.bind(request, (Session)((Object)value));
            }
            store.setAttribute(request, name, value);
        } else {
            if (this.temporarySessionAttributes == null) {
                this.temporarySessionAttributes = new HashMap<String, Serializable>(3);
            }
            this.temporarySessionAttributes.put(name, value);
        }
    }

    public synchronized int nextSequenceValue() {
        return this.sequence++;
    }

    public synchronized int nextPageId() {
        return this.pageId++;
    }

    public final IPageManager getPageManager() {
        IPageManager pageManager = Application.get().internalGetPageManager();
        return ((PageAccessSynchronizer)this.pageAccessSynchronizer.get()).adapt(pageManager);
    }

    @Override
    public void onEvent(IEvent<?> event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PageAccessSynchronizerProvider
    extends LazyInitializer<PageAccessSynchronizer> {
        private static final long serialVersionUID = 1L;

        private PageAccessSynchronizerProvider() {
        }

        protected PageAccessSynchronizer createInstance() {
            Duration timeout;
            if (Application.exists()) {
                timeout = Application.get().getRequestCycleSettings().getTimeout();
            } else {
                timeout = Duration.minutes((int)1);
                log.warn("PageAccessSynchronizer created outside of application thread, using default timeout: {}", (Object)timeout);
            }
            return new PageAccessSynchronizer(timeout);
        }
    }
}

