/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.value.IValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeModifier
extends Behavior
implements IClusterable {
    public static final String VALUELESS_ATTRIBUTE_ADD = "VA_ADD";
    public static final String VALUELESS_ATTRIBUTE_REMOVE = "VA_REMOVE";
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final IModel<?> replaceModel;

    @Deprecated
    public AttributeModifier(String attribute, boolean addAttributeIfNotPresent, IModel<?> replaceModel) {
        this(attribute, replaceModel);
    }

    public AttributeModifier(String attribute, IModel<?> replaceModel) {
        Args.notNull((Object)attribute, (String)"attribute");
        this.attribute = attribute;
        this.replaceModel = replaceModel;
    }

    public AttributeModifier(String attribute, Serializable value) {
        this(attribute, Model.of(value));
    }

    @Override
    public final void detach(Component component) {
        if (this.replaceModel != null) {
            this.replaceModel.detach();
        }
    }

    public final String getAttribute() {
        return this.attribute;
    }

    @Override
    public final void onComponentTag(Component component, ComponentTag tag) {
        if (tag.getType() != XmlTag.TagType.CLOSE) {
            this.replaceAttributeValue(component, tag);
        }
    }

    public final void replaceAttributeValue(Component component, ComponentTag tag) {
        if (this.isEnabled(component)) {
            IValueMap attributes = tag.getAttributes();
            Object replacementValue = this.getReplacementOrNull(component);
            if (VALUELESS_ATTRIBUTE_ADD.equals(replacementValue)) {
                attributes.put((Object)this.attribute, null);
            } else if (VALUELESS_ATTRIBUTE_REMOVE.equals(replacementValue)) {
                attributes.remove((Object)this.attribute);
            } else {
                String value = this.toStringOrNull(attributes.get((Object)this.attribute));
                String newValue = this.newValue(value, this.toStringOrNull(replacementValue));
                if (newValue != null) {
                    attributes.put((Object)this.attribute, (Object)newValue);
                }
            }
        }
    }

    public String toString() {
        return "[AttributeModifier attribute=" + this.attribute + ", replaceModel=" + this.replaceModel + "]";
    }

    private Object getReplacementOrNull(Component component) {
        IModel<?> model = this.replaceModel;
        if (model instanceof IComponentAssignedModel) {
            model = ((IComponentAssignedModel)model).wrapOnAssignment(component);
        }
        return model != null ? model.getObject() : null;
    }

    private String toStringOrNull(Object replacementValue) {
        return replacementValue != null ? replacementValue.toString() : null;
    }

    protected final IModel<?> getReplaceModel() {
        return this.replaceModel;
    }

    protected String newValue(String currentValue, String replacementValue) {
        return replacementValue;
    }

    public static AttributeModifier replace(String attribute, IModel<?> value) {
        return new AttributeModifier(attribute, value);
    }

    public static AttributeModifier replace(String attribute, Serializable value) {
        return new AttributeModifier(attribute, value);
    }

    public static AttributeAppender append(String attribute, IModel<?> value) {
        return new AttributeAppender(attribute, value).setSeparator(" ");
    }

    public static AttributeAppender append(String attribute, Serializable value) {
        return AttributeModifier.append(attribute, Model.of(value));
    }

    public static AttributeAppender prepend(String attribute, IModel<?> value) {
        return new AttributeAppender(attribute, (IModel)value){
            private static final long serialVersionUID = 1L;

            protected String newValue(String currentValue, String replacementValue) {
                return super.newValue(replacementValue, currentValue);
            }
        }.setSeparator(" ");
    }

    public static AttributeAppender prepend(String attribute, Serializable value) {
        return AttributeModifier.prepend(attribute, Model.of(value));
    }
}

