/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;
import org.apache.uima.test.junit_extension.TeePrintStream;
import org.apache.uima.test.junit_extension.UIMAResultPrinter;

public class JUnitTestRunner {
    private static final String SUITE_METHODNAME = "suite";
    private static final String ABORT_ON_FAIL = "-abortonfail";
    private static final String TEST_SUITE = "-suite";
    private static final String TEST_CASE = "-testcase";
    private static final String RESULT_OUTPUT = "-resultfile";
    private static final String CONSOLE_OUTPUT = "-consolefile";
    private static final String RESULT_OUTPUT_SHORT = "-rf";
    private static final String CONSOLE_OUTPUT_SHORT = "-cf";
    private static final String TEE_CONSOLE_OUTPUT = "-cpconsole";
    private static final String TEE_RESULT_OUTPUT = "-cpresult";
    private static boolean abortOnFail = false;
    private static boolean testCase = false;
    private static boolean testSuite = false;
    private static boolean teeResult = false;
    private static boolean teeConsole = false;
    private static boolean error = false;
    private static String testName = null;
    private static String consoleFileName = null;
    private static String resultFileName = null;

    public static void main(String[] args) {
        JUnitTestRunner jRun = new JUnitTestRunner();
        if (jRun.runTest(args)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public boolean runTest(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String currentArg = args[i];
            if (currentArg.startsWith("-")) {
                currentArg = currentArg.toLowerCase();
            }
            if (currentArg.equals(ABORT_ON_FAIL)) {
                abortOnFail = true;
                continue;
            }
            if (currentArg.equals(TEST_SUITE)) {
                if (i + 1 < args.length) {
                    testSuite = true;
                    testName = args[i + 1];
                    ++i;
                    continue;
                }
                error = true;
                continue;
            }
            if (currentArg.equals(TEST_CASE)) {
                if (i + 1 < args.length) {
                    testCase = true;
                    testName = args[i + 1];
                    ++i;
                    continue;
                }
                error = true;
                continue;
            }
            if (currentArg.equals(RESULT_OUTPUT) || currentArg.equals(RESULT_OUTPUT_SHORT)) {
                if (i + 1 < args.length) {
                    resultFileName = args[i + 1];
                    ++i;
                    continue;
                }
                error = true;
                continue;
            }
            if (currentArg.equals(CONSOLE_OUTPUT) || currentArg.equals(CONSOLE_OUTPUT_SHORT)) {
                if (i + 1 < args.length) {
                    consoleFileName = args[i + 1];
                    ++i;
                    continue;
                }
                error = true;
                continue;
            }
            if (currentArg.equals(TEE_CONSOLE_OUTPUT)) {
                teeConsole = true;
                continue;
            }
            if (!currentArg.equals(TEE_RESULT_OUTPUT)) continue;
            teeResult = true;
        }
        if (!testCase && !testSuite || error) {
            System.out.println("Usage: JUnitTestRunner [-abortOnFail] [-testcase <FullTestCaseClassname>]  [-suite <FullTestSuiteClassname] [-consoleFile <consoleOutputFileName>] [-resultFile <resultOutputFilename>] [-cpConsole] [-cpResult]");
        }
        TestRunner aTestRunner = new TestRunner();
        try {
            File resultFile = null;
            File consoleFile = null;
            PrintStream resultWriter = System.out;
            PrintStream consoleWriter = System.out;
            if (resultFileName != null) {
                resultFile = new File(resultFileName);
                resultFile.createNewFile();
                if (teeResult) {
                    PrintStream tempResultWriter = new PrintStream((OutputStream)new FileOutputStream(resultFile, false), true, "UTF-8");
                    resultWriter = new TeePrintStream(tempResultWriter, System.out);
                } else {
                    resultWriter = new PrintStream((OutputStream)new FileOutputStream(resultFile, false), true, "UTF-8");
                }
            }
            if (consoleFileName != null) {
                consoleFile = new File(consoleFileName);
                consoleFile.createNewFile();
                if (teeConsole) {
                    PrintStream tempConsoleWriter = new PrintStream((OutputStream)new FileOutputStream(consoleFile, false), true, "UTF-8");
                    consoleWriter = new TeePrintStream(tempConsoleWriter, System.out);
                } else {
                    consoleWriter = new PrintStream((OutputStream)new FileOutputStream(consoleFile, false), true, "UTF-8");
                }
                System.setOut(consoleWriter);
            }
            UIMAResultPrinter printer = new UIMAResultPrinter(resultWriter, abortOnFail, teeResult);
            aTestRunner.setPrinter((ResultPrinter)printer);
            Class<?> testClass = Class.forName(testName);
            TestSuite suite = new TestSuite();
            suite.setName(testName.substring(testName.lastIndexOf(".") + 1, testName.length()));
            if (testSuite) {
                Method suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
                Test test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                suite.addTest(test);
            }
            if (testCase) {
                suite.addTestSuite(testClass);
            }
            resultWriter.println("################################################################################################");
            resultWriter.println("# TestSuite: " + suite.getName());
            resultWriter.println("# Testcases: " + suite.countTestCases());
            resultWriter.println("# Test candidate: " + testName);
            resultWriter.println("# Abort on error: " + abortOnFail);
            resultWriter.println("# Result output filename: " + resultFileName);
            resultWriter.println("# Console output filename: " + consoleFileName);
            resultWriter.println("# Test start directory: " + System.getProperty("user.dir"));
            resultWriter.println("# Test starter: " + System.getProperty("user.name"));
            resultWriter.println("# OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
            resultWriter.println("# Command line run: " + System.getProperty("isCommandLine", "false"));
            GregorianCalendar cal = new GregorianCalendar();
            StringBuffer time = new StringBuffer(42);
            time.append("# Test started at: ");
            DateFormat dateTime = DateFormat.getDateInstance();
            time.append(dateTime.format(cal.getTime()));
            dateTime = DateFormat.getTimeInstance();
            time.append("  ");
            time.append(dateTime.format(cal.getTime()));
            resultWriter.println(time.toString());
            resultWriter.println("# Test runs with java version: " + System.getProperty("java.version"));
            resultWriter.println("# JUnitTestRunner version: 1.2");
            resultWriter.println("################################################################################################");
            TestResult results = aTestRunner.doRun((Test)suite);
            return results.wasSuccessful();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }
}

