/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.Level;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.XTalkTransporter;
import org.apache.vinci.transport.document.XTalkToSAX;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CASTransportable
extends DefaultHandler
implements Transportable {
    private CasPool myCasPool;
    private CAS myCas;
    private byte[] mybuf = new byte[512];
    private OutOfTypeSystemData outOfTypeSystemData;
    private boolean incomingCommand;
    private boolean incomingError;
    private boolean incomingExtraData;
    private String lastqName;
    private String command;
    private String error;
    private int ready;
    private ContentHandler handler;
    private VinciFrame extraDataFrame;
    public UimaContext uimaContext;
    public boolean includeDocText;
    public boolean ignoreResponse = false;

    public CASTransportable(CasPool casPool, OutOfTypeSystemData outOfTypeSystemData, UimaContext uimaContext, boolean includeDocText) {
        this.myCasPool = casPool;
        this.myCas = null;
        this.outOfTypeSystemData = outOfTypeSystemData;
        this.uimaContext = uimaContext;
        this.extraDataFrame = new VinciFrame();
        this.includeDocText = includeDocText;
    }

    public CASTransportable(CAS cas, OutOfTypeSystemData outOfTypeSystemData, UimaContext uimaContext, boolean includeDocText) {
        this.myCas = cas;
        this.myCasPool = null;
        this.outOfTypeSystemData = outOfTypeSystemData;
        this.uimaContext = uimaContext;
        this.extraDataFrame = new VinciFrame();
        this.includeDocText = includeDocText;
    }

    public VinciFrame getExtraDataFrame() {
        return this.extraDataFrame;
    }

    public OutOfTypeSystemData getOutOfTypeSystemData() {
        return this.outOfTypeSystemData;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public CAS getCas() {
        return this.myCas;
    }

    public KeyValuePair fromStream(InputStream is) throws IOException {
        boolean done = false;
        try {
            XTalkToSAX converter = new XTalkToSAX();
            converter.parse(is, (ContentHandler)this);
            done = true;
        }
        catch (SAXException e) {
            throw this.convertToIOException(e);
        }
        finally {
            if (!done) {
                this.cleanup();
            }
        }
        if (this.error != null) {
            return new KeyValuePair("vinci:ERROR", (FrameComponent)new FrameLeaf(this.error));
        }
        return null;
    }

    public void toStream(OutputStream os) throws IOException {
        try {
            UIMAFramework.getLogger().log(Level.FINEST, "Serializing CAS.");
            XCASSerializer xcasSerializer = new XCASSerializer(this.myCas.getTypeSystem(), this.uimaContext);
            xcasSerializer.setDocumentTypeName("Detag:DetagContent");
            xcasSerializer.setDocumentTextFeature(null);
            XTalkSerializer s = new XTalkSerializer(os, xcasSerializer);
            try {
                xcasSerializer.serialize(this.myCas, (ContentHandler)s, this.includeDocText, this.outOfTypeSystemData);
            }
            catch (SAXException e) {
                throw this.convertToIOException(e);
            }
            UIMAFramework.getLogger().log(Level.FINEST, "CAS Serialization Complete.");
        }
        catch (IOException e) {
            UIMAFramework.getLogger().log(Level.WARNING, e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            UIMAFramework.getLogger().log(Level.WARNING, e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (this.myCasPool != null) {
                this.myCasPool.releaseCas(this.myCas);
                this.myCas = null;
                UIMAFramework.getLogger().log(Level.FINEST, "Released CAS back to pool.");
            }
        }
    }

    public void cleanup() {
        if (this.myCas != null && this.myCasPool != null) {
            this.myCasPool.releaseCas(this.myCas);
            this.myCas = null;
        }
    }

    protected void finalize() {
        if (this.myCas != null && this.myCasPool != null) {
            Debug.p((String)"WARNING: releasing cas in finalizer.");
            this.myCasPool.releaseCas(this.myCas);
        }
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        if (this.ready > 0) {
            this.handler.startElement(uri, name, qName, atts);
        } else if ("vinci:COMMAND".equals(qName)) {
            this.incomingCommand = true;
        } else if ("vinci:ERROR".equals(qName) || "Error".equals(qName)) {
            this.incomingError = true;
        } else {
            this.lastqName = qName;
            this.incomingExtraData = true;
        }
        if ("KEYS".equals(qName)) {
            if (this.myCas == null) {
                this.myCas = this.myCasPool.getCas(0L);
            }
            this.myCas.reset();
            XCASDeserializer deser = new XCASDeserializer(this.myCas.getTypeSystem(), this.uimaContext);
            deser.setDocumentTypeName("Detag:DetagContent");
            this.handler = !this.ignoreResponse ? deser.getXCASHandler(this.myCas, this.outOfTypeSystemData) : new DefaultHandler();
            this.handler.startDocument();
            this.handler.startElement("", "CAS", "CAS", null);
            ++this.ready;
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if ("KEYS".equals(qName)) {
            --this.ready;
            if (this.ready == 0) {
                this.handler.endElement("", "CAS", "CAS");
                this.handler.endDocument();
            }
        }
        if (this.ready > 0) {
            this.handler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ready > 0) {
            this.handler.characters(ch, start, length);
        } else if (this.incomingCommand) {
            this.command = new String(ch, start, length);
            this.incomingCommand = false;
        } else if (this.incomingError) {
            this.error = new String(ch, start, length);
            this.incomingError = false;
        } else if (this.incomingExtraData) {
            this.extraDataFrame.fadd(this.lastqName, new String(ch, start, length));
            this.incomingExtraData = false;
        }
    }

    public void startDocument() throws SAXException {
        this.ready = 0;
    }

    public void endDocument() throws SAXException {
    }

    public SAXException wrapAsSAXException(IOException e) {
        SAXException saxEx = new SAXException(e.getMessage());
        saxEx.initCause(e);
        return saxEx;
    }

    private IOException convertToIOException(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof IOException)) continue;
            return (IOException)cause;
        }
        IOException ioex = new IOException();
        ioex.initCause(t);
        return ioex;
    }

    class XTalkSerializer
    extends DefaultHandler {
        OutputStream os;
        XCASSerializer serializer;
        boolean started;

        XTalkSerializer(OutputStream os, XCASSerializer s) {
            this.os = os;
            this.serializer = s;
        }

        public void startDocument() throws SAXException {
            try {
                this.os.write(XTalkTransporter.HEADER);
                XTalkTransporter.stringToBin((String)"vinci:FRAME", (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                XTalkTransporter.writeInt((int)0, (OutputStream)this.os);
                if (CASTransportable.this.command == null) {
                    XTalkTransporter.writeInt((int)1, (OutputStream)this.os);
                } else {
                    XTalkTransporter.writeInt((int)2, (OutputStream)this.os);
                    this.os.write(69);
                    XTalkTransporter.stringToBin((String)"vinci:COMMAND", (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                    XTalkTransporter.writeInt((int)0, (OutputStream)this.os);
                    XTalkTransporter.writeInt((int)1, (OutputStream)this.os);
                    this.os.write(115);
                    XTalkTransporter.stringToBin((String)CASTransportable.this.command, (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                }
                this.os.write(69);
                XTalkTransporter.stringToBin((String)"DATA", (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                XTalkTransporter.writeInt((int)0, (OutputStream)this.os);
                int children = 1 + CASTransportable.this.extraDataFrame.getKeyValuePairCount();
                XTalkTransporter.writeInt((int)children, (OutputStream)this.os);
                this.started = false;
                for (int i = 0; i < CASTransportable.this.extraDataFrame.getKeyValuePairCount(); ++i) {
                    KeyValuePair k = CASTransportable.this.extraDataFrame.getKeyValuePair(i);
                    this.os.write(69);
                    XTalkTransporter.stringToBin((String)k.getKey(), (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                    XTalkTransporter.writeInt((int)0, (OutputStream)this.os);
                    XTalkTransporter.writeInt((int)1, (OutputStream)this.os);
                    this.os.write(115);
                    XTalkTransporter.stringToBin((String)k.getValueAsString(), (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                }
            }
            catch (IOException e) {
                throw CASTransportable.this.wrapAsSAXException(e);
            }
        }

        void attributesToXTalk(Attributes attributes) throws IOException {
            int size = attributes.getLength();
            XTalkTransporter.writeInt((int)size, (OutputStream)this.os);
            for (int i = 0; i < size; ++i) {
                XTalkTransporter.stringToBin((String)attributes.getQName(i), (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
                XTalkTransporter.stringToBin((String)attributes.getValue(i), (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
            }
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
        }

        public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
            try {
                this.os.write(69);
                if (!this.started) {
                    Debug.Assert((boolean)"CAS".equals(qName));
                    this.started = true;
                    XTalkTransporter.stringToBin((String)"KEYS", (OutputStream)this.os);
                    this.started = true;
                } else {
                    XTalkTransporter.stringToBin((String)qName, (OutputStream)this.os);
                }
                this.attributesToXTalk(atts);
                XTalkTransporter.writeInt((int)this.serializer.getNumChildren(), (OutputStream)this.os);
            }
            catch (IOException e) {
                throw CASTransportable.this.wrapAsSAXException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.os.write(115);
                XTalkTransporter.stringToBin((char[])ch, (int)start, (int)length, (OutputStream)this.os, (byte[])CASTransportable.this.mybuf);
            }
            catch (IOException e) {
                throw CASTransportable.this.wrapAsSAXException(e);
            }
        }
    }
}

