/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.document;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.vinci.transport.XTalkTransporter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XTalkToSAX {
    public static final int INITIAL_BUF_SIZE = 256;
    private static final String cdataType = "CDATA";
    private char[] charBuffer;
    private byte[] byteBuffer;
    private AttributesImpl workAttributes;
    private InputStream is;
    private ContentHandler handler;

    public XTalkToSAX() {
        this.init(256);
    }

    public XTalkToSAX(int bufSize) {
        this.init(bufSize);
    }

    private void init(int bufSize) {
        this.workAttributes = new AttributesImpl();
        this.byteBuffer = new byte[bufSize];
        this.charBuffer = new char[bufSize];
    }

    public int bufferSize() {
        return this.byteBuffer.length;
    }

    public void resizeBuffers(int toSize) {
        if (this.byteBuffer.length != toSize) {
            this.byteBuffer = new byte[toSize];
            this.charBuffer = new char[toSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream is, ContentHandler handler) throws IOException, SAXException {
        this.is = is;
        this.handler = handler;
        try {
            int marker = is.read();
            if (marker == -1) {
                throw new EOFException();
            }
            if ((byte)marker != 88) {
                throw new IOException("Expected document marker: " + (char)marker);
            }
            int version = is.read();
            if ((byte)version != 0) {
                throw new IOException("Xtalk version code doesn't match 0: " + version);
            }
            handler.startDocument();
            this.doTopLevelParse();
            handler.endDocument();
            Object var6_5 = null;
            is = null;
            handler = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            is = null;
            handler = null;
            throw throwable;
        }
    }

    private void doTopLevelParse() throws IOException, SAXException {
        int marker;
        int top_field_count = XTalkTransporter.readInt(this.is);
        if (top_field_count < 1) {
            throw new IOException("No top level element.");
        }
        while ((marker = this.is.read()) == 112) {
            String target = this.consumeString();
            String data = this.consumeString();
            this.handler.processingInstruction(target, data);
            if (--top_field_count >= 1) continue;
            throw new IOException("No top level element.");
        }
        if ((byte)marker != 69) {
            throw new IOException("Expected element marker: " + (char)marker);
        }
        this.doElement();
        --top_field_count;
        while (top_field_count > 0) {
            if (this.is.read() != 112) {
                throw new IOException("Expected PI marker.");
            }
            this.doProcessingInstruction();
            --top_field_count;
        }
    }

    private void doProcessingInstruction() throws IOException, SAXException {
        String target = this.consumeString();
        String data = this.consumeString();
        this.handler.processingInstruction(target, data);
    }

    private void ensureCapacity(int bytesToRead) {
        if (this.byteBuffer.length < bytesToRead) {
            this.byteBuffer = new byte[this.byteBuffer.length + bytesToRead];
            this.charBuffer = new char[this.charBuffer.length + bytesToRead];
        }
    }

    private String consumeString() throws IOException {
        int bytesToRead = XTalkTransporter.readInt(this.is);
        this.ensureCapacity(bytesToRead);
        int charsRead = XTalkTransporter.consumeCharacters(this.is, this.byteBuffer, this.charBuffer, bytesToRead);
        return new String(this.charBuffer, 0, charsRead);
    }

    private void doElement() throws IOException, SAXException {
        String tagName = this.consumeString();
        int attribute_count = XTalkTransporter.readInt(this.is);
        this.workAttributes.clear();
        for (int i = 0; i < attribute_count; ++i) {
            String attrName = this.consumeString();
            String attrValue = this.consumeString();
            this.workAttributes.addAttribute(null, null, attrName, cdataType, attrValue);
        }
        this.handler.startElement(null, null, tagName, this.workAttributes);
        int field_count = XTalkTransporter.readInt(this.is);
        block6: for (int i = 0; i < field_count; ++i) {
            int marker = this.is.read();
            switch ((byte)marker) {
                case 112: {
                    this.doProcessingInstruction();
                    continue block6;
                }
                case 115: {
                    int bytesToRead = XTalkTransporter.readInt(this.is);
                    this.ensureCapacity(bytesToRead);
                    int charsRead = XTalkTransporter.consumeCharacters(this.is, this.byteBuffer, this.charBuffer, bytesToRead);
                    this.handler.characters(this.charBuffer, 0, charsRead);
                    continue block6;
                }
                case 69: {
                    this.doElement();
                    continue block6;
                }
                default: {
                    throw new IOException("Unexpected marker: " + (char)marker);
                }
            }
        }
        this.handler.endElement(null, null, tagName);
    }
}

