/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VinciFrame;

public class BaseClient {
    public static final int DEFAULT_SOCKET_TIMEOUT = 120000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private String host = null;
    private int port = 0;
    private TransportableFactory factory;
    private Socket socket = null;
    private InputStream is = null;
    private OutputStream os = null;
    private KeyValuePair header = null;
    private int socketTimeout = 120000;
    private int connectTimeout = 30000;
    private boolean retry = true;

    public BaseClient(String h, int p) throws IOException {
        this(h, p, VinciFrame.getVinciFrameFactory());
    }

    public BaseClient(String h, int p, int connect_timeout) throws IOException {
        this(h, p, VinciFrame.getVinciFrameFactory(), connect_timeout);
    }

    public BaseClient(String h, int p, TransportableFactory f) throws IOException {
        this.factory = f;
        this.host = h;
        this.port = p;
        this.open(this.host, this.port);
    }

    public BaseClient(String h, int p, TransportableFactory f, int timeout) throws IOException {
        this.factory = f;
        this.host = h;
        this.port = p;
        this.connectTimeout = timeout;
        this.open(this.host, this.port);
    }

    public BaseClient() {
        this(VinciFrame.getVinciFrameFactory());
    }

    public BaseClient(TransportableFactory f) {
        this.factory = f;
    }

    public BaseClient(TransportableFactory f, int timeout) {
        this.factory = f;
        this.connectTimeout = timeout;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public void setTransportableFactory(TransportableFactory f) {
        this.factory = f;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transportable sendAndReceive(Transportable in) throws IOException, ServiceException {
        try {
            if (!this.isOpen()) {
                this.open();
            }
            return this.sendAndReceiveWork(in, this.factory);
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    if (this.retry) {
                        this.reopen(e2);
                        return this.sendAndReceiveWork(in, this.factory);
                    }
                    throw e2;
                }
            }
            catch (SocketTimeoutException e3) {
                this.close();
                throw e3;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transportable sendAndReceive(Transportable in, int timeout) throws IOException, ServiceException {
        try {
            if (!this.isOpen()) {
                this.open();
            }
            return this.sendAndReceiveWork(in, this.factory, timeout);
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    if (this.retry) {
                        this.reopen(e2);
                        return this.sendAndReceiveWork(in, this.factory, timeout);
                    }
                    throw e2;
                }
            }
            catch (SocketTimeoutException e3) {
                this.close();
                throw e3;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transportable sendAndReceive(Transportable in, TransportableFactory f) throws IOException, ServiceException {
        try {
            if (!this.isOpen()) {
                this.open();
            }
            return this.sendAndReceiveWork(in, f);
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    if (this.retry) {
                        this.reopen(e2);
                        return this.sendAndReceiveWork(in, f);
                    }
                    throw e2;
                }
            }
            catch (SocketTimeoutException e3) {
                this.close();
                throw e3;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transportable sendAndReceive(Transportable in, TransportableFactory f, int timeout) throws IOException, ServiceException {
        try {
            if (!this.isOpen()) {
                this.open();
            }
            return this.sendAndReceiveWork(in, f, timeout);
        }
        catch (SocketTimeoutException e) {
            try {
                throw e;
                catch (IOException e2) {
                    if (this.retry) {
                        this.reopen(e2);
                        return this.sendAndReceiveWork(in, f, timeout);
                    }
                    throw e2;
                }
            }
            catch (SocketTimeoutException e3) {
                this.close();
                throw e3;
            }
        }
    }

    public VinciFrame rpc(Transportable query) throws IOException, ServiceException {
        return (VinciFrame)this.sendAndReceive(query);
    }

    public VinciFrame rpc(Transportable query, int timeout) throws IOException, ServiceException {
        return (VinciFrame)this.sendAndReceive(query, timeout);
    }

    public void send(Transportable in) throws IOException {
        block7: {
            try {
                try {
                    if (!this.isOpen()) {
                        this.open();
                    }
                    in.toStream(this.os);
                    this.os.flush();
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (this.retry) {
                        this.reopen(e);
                        in.toStream(this.os);
                        this.os.flush();
                        break block7;
                    }
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                this.close();
                throw e;
            }
        }
    }

    public Transportable receive() throws IOException, ServiceException {
        if (!this.isOpen()) {
            throw new IOException("Socket not open");
        }
        Transportable out = this.factory.makeTransportable();
        this.header = out.fromStream(this.is);
        if (this.header != null && this.header.key.equals("vinci:ERROR")) {
            throw new ServiceException(this.header.getValueAsString(), out);
        }
        return out;
    }

    public void close() {
        if (this.isOpen()) {
            try {
                this.socket.close();
                this.is = null;
                this.os = null;
                this.socket = null;
            }
            catch (IOException e) {
                Debug.reportException(e, "Could not close connection.");
            }
        }
    }

    public boolean isOpen() {
        return this.socket != null && this.os != null && this.is != null;
    }

    public void setRetry(boolean to) {
        this.retry = to;
    }

    public KeyValuePair getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transportable sendAndReceive(Transportable in, String host_name, int p, TransportableFactory f) throws IOException, ServiceException {
        BaseClient tempClient = new BaseClient(host_name, p, f);
        tempClient.setRetry(false);
        try {
            Transportable transportable = tempClient.sendAndReceive(in);
            Object var7_6 = null;
            tempClient.close();
            return transportable;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            tempClient.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transportable sendAndReceive(Transportable in, String host_name, int p, TransportableFactory f, int socket_timeout) throws IOException, ServiceException {
        BaseClient tempClient = new BaseClient(host_name, p, f);
        tempClient.setSocketTimeout(socket_timeout);
        tempClient.setRetry(false);
        try {
            Transportable transportable = tempClient.sendAndReceive(in);
            Object var8_7 = null;
            tempClient.close();
            return transportable;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            tempClient.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transportable sendAndReceive(Transportable in, String host_name, int p, TransportableFactory f, int socket_timeout, int connect_timeout) throws IOException, ServiceException {
        BaseClient tempClient = new BaseClient(host_name, p, f, connect_timeout);
        tempClient.setSocketTimeout(socket_timeout);
        tempClient.setRetry(false);
        try {
            Transportable transportable = tempClient.sendAndReceive(in);
            Object var9_8 = null;
            tempClient.close();
            return transportable;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            tempClient.close();
            throw throwable;
        }
    }

    public static VinciFrame rpc(Transportable in, String host_name, int p) throws IOException, ServiceException {
        return (VinciFrame)BaseClient.sendAndReceive(in, host_name, p, VinciFrame.getVinciFrameFactory());
    }

    public static VinciFrame rpc(Transportable in, String host_name, int p, int socket_timeout) throws IOException, ServiceException {
        return (VinciFrame)BaseClient.sendAndReceive(in, host_name, p, VinciFrame.getVinciFrameFactory(), socket_timeout);
    }

    public static VinciFrame rpc(Transportable in, String host_name, int p, int socket_timeout, int connect_timeout) throws IOException, ServiceException {
        return (VinciFrame)BaseClient.sendAndReceive(in, host_name, p, VinciFrame.getVinciFrameFactory(), socket_timeout, connect_timeout);
    }

    protected Transportable sendAndReceiveWork(Transportable in, TransportableFactory f) throws IOException, ServiceException {
        in.toStream(this.os);
        this.os.flush();
        Transportable out = f.makeTransportable();
        this.header = out.fromStream(this.is);
        if (this.header != null && this.header.key.equals("vinci:ERROR")) {
            throw new ServiceException(this.header.getValueAsString(), out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transportable sendAndReceiveWork(Transportable in, TransportableFactory f, int timeout) throws IOException, ServiceException {
        Transportable transportable;
        this.socket.setSoTimeout(timeout);
        try {
            transportable = this.sendAndReceiveWork(in, f);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.socket.setSoTimeout(this.socketTimeout);
            throw throwable;
        }
        this.socket.setSoTimeout(this.socketTimeout);
        return transportable;
    }

    protected void reopen(Exception e) throws IOException {
        Debug.p("Trying to reopen connection due to exception: " + e.getMessage());
        this.close();
        this.open();
    }

    protected final void open(String h, int p) throws IOException {
        this.host = h;
        this.port = p;
        this.open();
    }

    public final void open() throws IOException {
        this.socket = new Socket();
        InetAddress addr = InetAddress.getByName(this.host);
        InetSocketAddress socketAddress = new InetSocketAddress(addr, this.port);
        this.socket.connect(socketAddress, this.connectTimeout);
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(this.socketTimeout);
        this.socket.setKeepAlive(this.isSocketKeepAliveEnabled());
        this.is = new BufferedInputStream(this.socket.getInputStream());
        this.os = new BufferedOutputStream(this.socket.getOutputStream());
    }

    public void open(Socket use_me) throws IOException {
        this.setRetry(false);
        this.socket = use_me;
        this.socket.setSoTimeout(this.socketTimeout);
        this.socket.setKeepAlive(this.isSocketKeepAliveEnabled());
        this.is = new BufferedInputStream(this.socket.getInputStream());
        this.os = new BufferedOutputStream(this.socket.getOutputStream());
    }

    public void setSocketTimeout(int millis) throws IOException {
        if (this.socket != null) {
            this.socket.setSoTimeout(millis);
        }
        this.socketTimeout = millis;
    }

    protected boolean isSocketKeepAliveEnabled() {
        return true;
    }
}

