/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextAccessController;
import org.apache.naming.StringManager;

public class ContextBindings {
    private static final Hashtable<Object, Context> contextNameBindings = new Hashtable();
    private static final Hashtable<Thread, Context> threadBindings = new Hashtable();
    private static final Hashtable<Thread, Object> threadNameBindings = new Hashtable();
    private static final Hashtable<ClassLoader, Context> clBindings = new Hashtable();
    private static final Hashtable<ClassLoader, Object> clNameBindings = new Hashtable();
    protected static final StringManager sm = StringManager.getManager("org.apache.naming");

    public static void bindContext(Object name, Context context) {
        ContextBindings.bindContext(name, context, null);
    }

    public static void bindContext(Object name, Context context, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            contextNameBindings.put(name, context);
        }
    }

    public static void unbindContext(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            contextNameBindings.remove(name);
        }
    }

    static Context getContext(Object name) {
        return contextNameBindings.get(name);
    }

    public static void bindThread(Object name, Object token) throws NamingException {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            Context context = contextNameBindings.get(name);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", name));
            }
            threadBindings.put(Thread.currentThread(), context);
            threadNameBindings.put(Thread.currentThread(), name);
        }
    }

    public static void unbindThread(Object name, Object token) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            threadBindings.remove(Thread.currentThread());
            threadNameBindings.remove(Thread.currentThread());
        }
    }

    public static Context getThread() throws NamingException {
        Context context = threadBindings.get(Thread.currentThread());
        if (context == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return context;
    }

    static Object getThreadName() throws NamingException {
        Object name = threadNameBindings.get(Thread.currentThread());
        if (name == null) {
            throw new NamingException(sm.getString("contextBindings.noContextBoundToThread"));
        }
        return name;
    }

    public static boolean isThreadBound() {
        return threadBindings.containsKey(Thread.currentThread());
    }

    public static void bindClassLoader(Object name, Object token, ClassLoader classLoader) throws NamingException {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            Context context = contextNameBindings.get(name);
            if (context == null) {
                throw new NamingException(sm.getString("contextBindings.unknownContext", name));
            }
            clBindings.put(classLoader, context);
            clNameBindings.put(classLoader, name);
        }
    }

    public static void unbindClassLoader(Object name, Object token, ClassLoader classLoader) {
        if (ContextAccessController.checkSecurityToken(name, token)) {
            Object n = clNameBindings.get(classLoader);
            if (n == null || !n.equals(name)) {
                return;
            }
            clBindings.remove(classLoader);
            clNameBindings.remove(classLoader);
        }
    }

    public static Context getClassLoader() throws NamingException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Context context = null;
        do {
            if ((context = clBindings.get(cl)) == null) continue;
            return context;
        } while ((cl = cl.getParent()) != null);
        throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
    }

    static Object getClassLoaderName() throws NamingException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Object name = null;
        do {
            if ((name = clNameBindings.get(cl)) == null) continue;
            return name;
        } while ((cl = cl.getParent()) != null);
        throw new NamingException(sm.getString("contextBindings.noContextBoundToCL"));
    }

    public static boolean isClassLoaderBound() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        do {
            if (!clBindings.containsKey(cl)) continue;
            return true;
        } while ((cl = cl.getParent()) != null);
        return false;
    }
}

