/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.jasper.compiler.JarScannerFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldParser;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.SAXException;

public class TldScanner {
    private static final Log log = LogFactory.getLog(TldScanner.class);
    private static final String MSG = "org.apache.jasper.servlet.TldScanner";
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private final ServletContext context;
    private final TldParser tldParser;
    private final Map<String, TldResourcePath> uriTldResourcePathMap = new HashMap<String, TldResourcePath>();
    private final Map<TldResourcePath, TaglibXml> tldResourcePathTaglibXmlMap = new HashMap<TldResourcePath, TaglibXml>();
    private final List<String> listeners = new ArrayList<String>();

    public TldScanner(ServletContext context, boolean namespaceAware, boolean validation, boolean blockExternal) {
        this.context = context;
        this.tldParser = new TldParser(namespaceAware, validation, blockExternal);
    }

    public void scan() throws IOException, SAXException {
        this.scanPlatform();
        this.scanJspConfig();
        this.scanResourcePaths(WEB_INF);
        this.scanJars();
    }

    public Map<String, TldResourcePath> getUriTldResourcePathMap() {
        return this.uriTldResourcePathMap;
    }

    public Map<TldResourcePath, TaglibXml> getTldResourcePathTaglibXmlMap() {
        return this.tldResourcePathTaglibXmlMap;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.tldParser.setClassLoader(classLoader);
    }

    protected void scanPlatform() {
    }

    protected void scanJspConfig() throws IOException, SAXException {
        JspConfigDescriptor jspConfigDescriptor = this.context.getJspConfigDescriptor();
        if (jspConfigDescriptor == null) {
            return;
        }
        Collection descriptors = jspConfigDescriptor.getTaglibs();
        for (TaglibDescriptor descriptor : descriptors) {
            URL url;
            String taglibURI = descriptor.getTaglibURI();
            String resourcePath = descriptor.getTaglibLocation();
            if (!resourcePath.startsWith("/")) {
                resourcePath = WEB_INF + resourcePath;
            }
            if (this.uriTldResourcePathMap.containsKey(taglibURI)) {
                log.warn((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlSkip", resourcePath, taglibURI));
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlAdd", resourcePath, taglibURI));
            }
            if ((url = this.context.getResource(resourcePath)) != null) {
                TldResourcePath tldResourcePath = resourcePath.endsWith(".jar") ? new TldResourcePath(url, resourcePath, "META-INF/taglib.tld") : new TldResourcePath(url, resourcePath);
                TaglibXml tld = this.tldParser.parse(tldResourcePath);
                this.uriTldResourcePathMap.put(taglibURI, tldResourcePath);
                this.tldResourcePathTaglibXmlMap.put(tldResourcePath, tld);
                if (tld.getListeners() == null) continue;
                this.listeners.addAll(tld.getListeners());
                continue;
            }
            log.warn((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlFailPathDoesNotExist", resourcePath, taglibURI));
        }
    }

    protected void scanResourcePaths(String startPath) throws IOException, SAXException {
        Set dirList = this.context.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.startsWith("/WEB-INF/classes/") || path.startsWith("/WEB-INF/lib/")) continue;
                if (path.endsWith("/")) {
                    this.scanResourcePaths(path);
                    continue;
                }
                if (path.startsWith("/WEB-INF/tags/")) {
                    if (!path.endsWith("/implicit.tld")) continue;
                    this.parseTld(path);
                    continue;
                }
                if (!path.endsWith(TLD_EXT)) continue;
                this.parseTld(path);
            }
        }
    }

    public void scanJars() {
        JarScanner scanner = JarScannerFactory.getJarScanner(this.context);
        TldScannerCallback callback = new TldScannerCallback();
        scanner.scan(JarScanType.TLD, this.context, (JarScannerCallback)callback);
        if (callback.scanFoundNoTLDs()) {
            log.info((Object)Localizer.getMessage("jsp.tldCache.noTldSummary"));
        }
    }

    private void parseTld(String resourcePath) throws IOException, SAXException {
        TldResourcePath tldResourcePath = new TldResourcePath(this.context.getResource(resourcePath), resourcePath);
        this.parseTld(tldResourcePath);
    }

    private void parseTld(TldResourcePath path) throws IOException, SAXException {
        if (this.tldResourcePathTaglibXmlMap.containsKey(path)) {
            return;
        }
        TaglibXml tld = this.tldParser.parse(path);
        String uri = tld.getUri();
        if (uri != null && !this.uriTldResourcePathMap.containsKey(uri)) {
            this.uriTldResourcePathMap.put(uri, path);
        }
        this.tldResourcePathTaglibXmlMap.put(path, tld);
        if (tld.getListeners() != null) {
            this.listeners.addAll(tld.getListeners());
        }
    }

    private class TldScannerCallback
    implements JarScannerCallback {
        private boolean tldFound = false;
        private boolean jarFound = false;

        private TldScannerCallback() {
        }

        public void scan(JarURLConnection urlConn, String webappPath, boolean isWebapp) throws IOException {
            if (!this.jarFound) {
                this.jarFound = true;
            }
            boolean found = false;
            URL jarURL = null;
            try (Jar jar = JarFactory.newInstance((URL)urlConn.getURL());){
                jarURL = jar.getJarFileURL();
                jar.nextEntry();
                String entryName = jar.getEntryName();
                while (entryName != null) {
                    if (entryName.startsWith("META-INF/") && entryName.endsWith(TldScanner.TLD_EXT)) {
                        found = true;
                        TldResourcePath tldResourcePath = new TldResourcePath(jarURL, webappPath, entryName);
                        try {
                            TldScanner.this.parseTld(tldResourcePath);
                        }
                        catch (SAXException e) {
                            throw new IOException(e);
                        }
                    }
                    jar.nextEntry();
                    entryName = jar.getEntryName();
                }
            }
            if (found) {
                this.tldFound = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)Localizer.getMessage("jsp.tldCache.noTldInJar", jarURL.toString()));
            }
        }

        public void scan(File file, final String webappPath, boolean isWebapp) throws IOException {
            File metaInf;
            if (!this.jarFound) {
                this.jarFound = true;
            }
            if (!(metaInf = new File(file, "META-INF")).isDirectory()) {
                return;
            }
            final Path filePath = file.toPath();
            Files.walkFileTree(metaInf.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.getFileName().toString().toLowerCase(Locale.ENGLISH).endsWith(TldScanner.TLD_EXT)) {
                        return FileVisitResult.CONTINUE;
                    }
                    String subPath = file.subpath(filePath.getNameCount(), file.getNameCount()).toString();
                    if ('/' != File.separatorChar) {
                        subPath = subPath.replace(File.separatorChar, '/');
                    }
                    String resourcePath = webappPath + "/" + subPath;
                    try {
                        URL url = file.toUri().toURL();
                        TldResourcePath path = new TldResourcePath(url, resourcePath);
                        TldScanner.this.parseTld(path);
                        TldScannerCallback.this.tldFound = true;
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        public void scanWebInfClasses() throws IOException {
            String webappPath = "/WEB-INF/classes";
            String realPath = TldScanner.this.context.getRealPath(webappPath);
            File webInfClasses = new File(realPath);
            this.scan(webInfClasses, webappPath, true);
        }

        private boolean scanFoundNoTLDs() {
            return this.jarFound && !this.tldFound;
        }
    }
}

