/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordReader;

public class PigAvroInputFormat
extends FileInputFormat<NullWritable, Writable> {
    private Schema readerSchema = null;
    private boolean useMultipleSchemas = false;
    private boolean ignoreBadFiles = false;
    private Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap;

    public PigAvroInputFormat() {
    }

    public PigAvroInputFormat(Schema readerSchema, boolean ignoreBadFiles, Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap, boolean useMultipleSchemas) {
        this.readerSchema = readerSchema;
        this.ignoreBadFiles = ignoreBadFiles;
        this.schemaToMergedSchemaMap = schemaToMergedSchemaMap;
        this.useMultipleSchemas = useMultipleSchemas;
    }

    public RecordReader<NullWritable, Writable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        context.setStatus(split.toString());
        return new PigAvroRecordReader(context, (FileSplit)split, this.readerSchema, this.ignoreBadFiles, this.schemaToMergedSchemaMap, this.useMultipleSchemas);
    }
}

