/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pig.impl.io.BufferedPositionedInputStream;
import org.apache.tools.bzip2r.CBZip2InputStream;

class XMLLoaderBufferedPositionedInputStream
extends BufferedPositionedInputStream {
    public static final int S_START = 0;
    public static final int S_MATCH_PREFIX = 1;
    public static final int S_MATCH_TAG = 2;
    InputStream wrapperIn;
    boolean _isReadable;
    private long maxBytesReadable = 0L;
    long bytesRead = 0L;
    long end = 0L;

    public XMLLoaderBufferedPositionedInputStream(InputStream in) {
        super(in);
        this.wrapperIn = in;
        this.setReadable(true);
    }

    public XMLLoaderBufferedPositionedInputStream(InputStream in, long start, long end) {
        this(in);
        this.end = end;
        this.maxBytesReadable = end - start;
    }

    private void setReadable(boolean flag) {
        this._isReadable = flag;
    }

    public boolean isReadable() {
        return this._isReadable;
    }

    public int read() throws IOException {
        return this.wrapperIn.read();
    }

    private byte[] collectUntilEndTag(String tagName, long limit) {
        byte[] tmp = tagName.getBytes();
        ByteArrayOutputStream collectBuf = new ByteArrayOutputStream(1024);
        int depth = 0;
        boolean insideTag = false;
        boolean closingTag = false;
        int last_b = -1;
        while (true) {
            int b = -1;
            try {
                b = this.read();
                ++this.bytesRead;
                if (b == -1) {
                    collectBuf.reset();
                    this.setReadable(false);
                    break;
                }
                collectBuf.write((byte)b);
                if (b == 60) {
                    insideTag = true;
                    closingTag = false;
                } else if (b == 62) {
                    if (last_b == 47) {
                        closingTag = true;
                    }
                    insideTag = false;
                    if (closingTag) {
                        if (depth == 0) break;
                        --depth;
                    }
                } else if (b == 47 && last_b == 60) {
                    closingTag = true;
                } else if (insideTag && last_b == 60) {
                    ++depth;
                }
            }
            catch (IOException e) {
                this.setReadable(false);
                return null;
            }
            last_b = b;
        }
        return collectBuf.toByteArray();
    }

    private byte[] skipToTag(String tagName, long limit) throws IOException {
        byte[] tmp = tagName.getBytes();
        byte[] tag = new byte[tmp.length + 1];
        tag[0] = 60;
        for (int i = 0; i < tmp.length; ++i) {
            tag[1 + i] = tmp[i];
        }
        ByteArrayOutputStream matchBuf = new ByteArrayOutputStream(512);
        int idxTagChar = 0;
        int state = 0;
        while (this.splitBoundaryCriteria(this.wrapperIn) || matchBuf.size() > 0) {
            byte b = -1;
            try {
                b = this.read();
                ++this.bytesRead;
                if (b == -1) {
                    state = 0;
                    matchBuf.reset();
                    this.setReadable(false);
                    break;
                }
                switch (state) {
                    case 0: {
                        if (b == tag[idxTagChar]) {
                            matchBuf.write(b);
                            if (++idxTagChar != tag.length) break;
                            state = 1;
                            break;
                        }
                        idxTagChar = 0;
                        matchBuf.reset();
                        break;
                    }
                    case 1: {
                        if (Character.isWhitespace(b) || b == 47 || b == 62) {
                            matchBuf.write(b);
                            state = 2;
                            break;
                        }
                        idxTagChar = 0;
                        matchBuf.reset();
                        state = 0;
                        break;
                    }
                    case 2: {
                        matchBuf.write(b);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid state: " + state);
                    }
                }
                if ((state != 2 || b != 62 && !Character.isWhitespace(b)) && (state == 2 || this.getPosition() <= limit)) continue;
                break;
            }
            catch (IOException e) {
                this.setReadable(false);
                return null;
            }
        }
        return matchBuf.toByteArray();
    }

    private boolean splitBoundaryCriteria(InputStream wrapperIn2) throws IOException {
        if (wrapperIn2 instanceof CBZip2InputStream) {
            return ((CBZip2InputStream)wrapperIn2).getPos() <= this.end;
        }
        return this.bytesRead <= this.maxBytesReadable;
    }

    byte[] collectTag(String tagName, long limit) throws IOException {
        byte[] untilTag;
        ByteArrayOutputStream collectBuf = new ByteArrayOutputStream(1024);
        byte[] beginTag = this.skipToTag(tagName, limit);
        if (beginTag.length > 2 && beginTag[beginTag.length - 2] == 47 && beginTag[beginTag.length - 1] == 62) {
            return beginTag;
        }
        if (beginTag.length > 0 && (untilTag = this.collectUntilEndTag(tagName, limit)).length > 0) {
            for (byte b : beginTag) {
                collectBuf.write(b);
            }
            for (byte b : untilTag) {
                collectBuf.write(b);
            }
        }
        return collectBuf.toByteArray();
    }
}

