/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringDictionary {
    private Map<StringList, String> entries = new HashMap<StringList, String>();

    public StringDictionary() {
    }

    public StringDictionary(InputStream in) throws IOException, InvalidFormatException {
        DictionarySerializer.create((InputStream)in, (EntryInserter)new EntryInserter(){

            public void insert(Entry entry) throws InvalidFormatException {
                String valueString = entry.getAttributes().getValue("value");
                StringDictionary.this.put(entry.getTokens(), valueString);
            }
        });
    }

    public String get(StringList key) {
        return this.entries.get(key);
    }

    public void put(StringList key, String value) {
        this.entries.put(key, value);
    }

    Iterator<StringList> iterator() {
        return this.entries.keySet().iterator();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entryIterator = new Iterator<Entry>(){
            private Iterator<StringList> mDictionaryIterator;
            {
                this.mDictionaryIterator = StringDictionary.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            @Override
            public Entry next() {
                StringList tokens = this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue("value", StringDictionary.this.get(tokens));
                return new Entry(tokens, attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize((OutputStream)out, (Iterator)entryIterator);
    }
}

