/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.uima.namefind.AbstractNameFinder;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryNameFinder
extends AbstractNameFinder {
    private TokenNameFinder mNameFinder;

    public DictionaryNameFinder() {
        super("OpenNLP Dictionary Name annotator");
    }

    @Override
    public void initialize() throws ResourceInitializationException {
        Dictionary nameFinderDictionary;
        try {
            String modelName = AnnotatorUtil.getRequiredStringParameter(this.context, "opennlp.uima.Dictionary");
            InputStream inModel = AnnotatorUtil.getResourceAsStream(this.context, modelName);
            nameFinderDictionary = new Dictionary(inModel);
        }
        catch (IOException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_dictionary_reading", new Object[]{e.getMessage()});
        }
        this.mNameFinder = new opennlp.tools.namefind.DictionaryNameFinder(nameFinderDictionary);
    }

    @Override
    protected Span[] find(CAS cas, AnnotationFS sentence, List<AnnotationFS> tokenAnnotations, String[] tokens) {
        return this.mNameFinder.find(tokens);
    }

    public void destroy() {
        this.mNameFinder = null;
    }
}

