/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.Span;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.ContainingConstraint;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNameFinder
extends CasAnnotator_ImplBase {
    protected final String name;
    protected Type mSentenceType;
    protected Type mTokenType;
    protected Type mNameType;
    protected UimaContext context;
    protected Logger mLogger;
    private Boolean isRemoveExistingAnnotations;

    AbstractNameFinder(String name) {
        this.name = name;
    }

    protected void initialize() throws ResourceInitializationException {
    }

    public final void initialize(UimaContext context) throws ResourceInitializationException {
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the " + this.name + ".");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(context, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
        this.initialize();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mNameType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.NameType");
    }

    protected void postProcessAnnotations(Span[] detectedNames, AnnotationFS[] nameAnnotations) {
    }

    protected void documentDone(CAS cas) {
    }

    protected abstract Span[] find(CAS var1, AnnotationFS var2, List<AnnotationFS> var3, String[] var4);

    public final void process(CAS cas) {
        AnnotationIndex sentenceIndex = cas.getAnnotationIndex(this.mSentenceType);
        for (AnnotationFS sentenceAnnotation : sentenceIndex) {
            if (this.isRemoveExistingAnnotations.booleanValue()) {
                UimaUtil.removeAnnotations(cas, sentenceAnnotation, this.mNameType);
            }
            ContainingConstraint containingConstraint = new ContainingConstraint(sentenceAnnotation);
            FSIterator tokenIterator = cas.createFilteredIterator(cas.getAnnotationIndex(this.mTokenType).iterator(), (FSMatchConstraint)containingConstraint);
            ArrayList<AnnotationFS> tokenAnnotationList = new ArrayList<AnnotationFS>();
            ArrayList<String> tokenList = new ArrayList<String>();
            while (tokenIterator.hasNext()) {
                AnnotationFS tokenAnnotation = (AnnotationFS)tokenIterator.next();
                tokenAnnotationList.add(tokenAnnotation);
                tokenList.add(tokenAnnotation.getCoveredText());
            }
            Span[] names = this.find(cas, sentenceAnnotation, tokenAnnotationList, tokenList.toArray(new String[tokenList.size()]));
            AnnotationFS[] nameAnnotations = new AnnotationFS[names.length];
            for (int i = 0; i < names.length; ++i) {
                int startIndex = ((AnnotationFS)tokenAnnotationList.get(names[i].getStart())).getBegin();
                int endIndex = ((AnnotationFS)tokenAnnotationList.get(names[i].getEnd() - 1)).getEnd();
                nameAnnotations[i] = cas.createAnnotation(this.mNameType, startIndex, endIndex);
                cas.getIndexRepository().addFS((FeatureStructure)nameAnnotations[i]);
            }
            this.postProcessAnnotations(names, nameAnnotations);
        }
        this.documentDone(cas);
    }
}

