/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreemnets.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package opennlp.uima.util;

/**
 * This class contains constants for the exception messages in the exception
 * massage catalog.
 */
public class ExceptionMessages {
    
  public static final String MESSAGE_CATALOG = "opennlp.uima.util.ExceptionMessages";

  public static final String IO_ERROR_MODEL_READING = "io_error_model_reading";
  public static final String IO_ERROR_DICTIONARY_READING = "io_error_dictionary_reading";
  public static final String INVALID_DICTIONARY_FORMAT = "invalid_dictionary_format";

  public static final String PARAMETER_NOT_FOUND = "parameter_not_found";
  public static final String WRONG_PARAMETER_TYPE = "wrong_parameter_type";

  public static final String TYPE_NOT_FOUND = "type_not_found";
  public static final String FEATURE_NOT_FOUND = "feature_not_found";

  public static final String WRONG_FEATURE_TYPE = "wrong_feature_type";
}