/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.GenericModelReader;
import opennlp.model.MaxentModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceModel
extends BaseModel {
    private static final String COMPONENT_NAME = "SentenceDetectorME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "sent.model";
    private static final String ABBREVIATIONS_ENTRY_NAME = "abbreviations.dictionary";
    private static final String TOKEN_END_PROPERTY = "useTokenEnd";

    public SentenceModel(String languageCode, AbstractModel sentModel, boolean useTokenEnd, Dictionary abbreviations, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, sentModel);
        this.setManifestProperty(TOKEN_END_PROPERTY, Boolean.toString(useTokenEnd));
        if (abbreviations != null) {
            this.artifactMap.put(ABBREVIATIONS_ENTRY_NAME, abbreviations);
        }
        this.checkArtifactMap();
    }

    public SentenceModel(String languageCode, AbstractModel sentModel, boolean useTokenEnd, Dictionary abbreviations) {
        this(languageCode, sentModel, useTokenEnd, abbreviations, null);
    }

    public SentenceModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Unable to find sent.model maxent model!");
        }
        if (!ModelUtil.validateOutcomes((MaxentModel)this.getMaxentModel(), "s", "n")) {
            throw new InvalidFormatException("The maxent model is not compatible with the sentence detector!");
        }
        if (this.getManifestProperty(TOKEN_END_PROPERTY) == null) {
            throw new InvalidFormatException("useTokenEnd is a mandatory property!");
        }
        Object abbreviationsEntry = this.artifactMap.get(ABBREVIATIONS_ENTRY_NAME);
        if (abbreviationsEntry != null && !(abbreviationsEntry instanceof Dictionary)) {
            throw new InvalidFormatException("Abbreviations dictionary has wrong type!");
        }
    }

    public AbstractModel getMaxentModel() {
        return (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public Dictionary getAbbreviations() {
        return (Dictionary)this.artifactMap.get(ABBREVIATIONS_ENTRY_NAME);
    }

    public boolean useTokenEnd() {
        return Boolean.parseBoolean(this.getManifestProperty(TOKEN_END_PROPERTY));
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, InvalidFormatException {
        if (args.length < 3) {
            System.err.println("SentenceModel [-abbreviationsDictionary] [-useTokenEnd] languageCode packageName modelName");
            System.exit(1);
        }
        int ai = 0;
        Dictionary abbreviations = null;
        if ("-abbreviationsDictionary".equals(args[ai])) {
            int n = ++ai;
            ++ai;
            abbreviations = new Dictionary(new FileInputStream(args[n]));
        }
        boolean useTokenEnd = false;
        if ("-useTokenEnd".equals(args[ai])) {
            useTokenEnd = true;
        }
        int n = ++ai;
        String languageCode = args[n];
        int n2 = ++ai;
        String packageName = args[n2];
        String modelName = args[++ai];
        AbstractModel model = new GenericModelReader(new File(modelName)).getModel();
        SentenceModel packageModel = new SentenceModel(languageCode, model, useTokenEnd, abbreviations);
        packageModel.serialize(new FileOutputStream(packageName));
    }
}

