/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenNameFinderCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private final String type;
    private final byte[] featureGeneratorBytes;
    private final Map<String, Object> resources;
    private TokenNameFinderEvaluationMonitor[] listeners;
    private FMeasure fmeasure = new FMeasure();

    @Deprecated
    public TokenNameFinderCrossValidator(String languageCode, int cutoff, int iterations) {
        this(languageCode, null, cutoff, iterations);
    }

    @Deprecated
    public TokenNameFinderCrossValidator(String languageCode, String type, int cutoff, int iterations) {
        this.languageCode = languageCode;
        this.type = type;
        this.params = ModelUtil.createTrainingParameters(iterations, cutoff);
        this.featureGeneratorBytes = null;
        this.resources = Collections.emptyMap();
    }

    @Deprecated
    public TokenNameFinderCrossValidator(String languageCode, String type, byte[] featureGeneratorBytes, Map<String, Object> resources, int iterations, int cutoff) {
        this.languageCode = languageCode;
        this.type = type;
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.params = ModelUtil.createTrainingParameters(iterations, cutoff);
    }

    public TokenNameFinderCrossValidator(String languageCode, String type, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources, TokenNameFinderEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.type = type;
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.params = trainParams;
        this.listeners = listeners;
    }

    public void evaluate(ObjectStream<NameSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<NameSample> partitioner = new CrossValidationPartitioner<NameSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<NameSample> trainingSampleStream = partitioner.next();
            TokenNameFinderModel model = NameFinderME.train(this.languageCode, this.type, trainingSampleStream, this.params, this.featureGeneratorBytes, this.resources);
            TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

