/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.util.ReverseListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiscourseElement {
    private List<MentionContext> extents = new ArrayList<MentionContext>(1);
    private int id = -1;
    private MentionContext lastExtent;

    public DiscourseElement(MentionContext mention) {
        this.lastExtent = mention;
        this.extents.add(mention);
    }

    public Iterator<MentionContext> getRecentMentions() {
        return new ReverseListIterator<MentionContext>(this.extents);
    }

    public Iterator<MentionContext> getMentions() {
        return this.extents.listIterator();
    }

    public int getNumMentions() {
        return this.extents.size();
    }

    public void addMention(MentionContext mention) {
        this.extents.add(mention);
        this.lastExtent = mention;
    }

    public MentionContext getLastExtent() {
        return this.lastExtent;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        Iterator<MentionContext> ei = this.extents.iterator();
        MentionContext ex = ei.next();
        StringBuffer de = new StringBuffer();
        de.append("[ ").append(ex.toText());
        while (ei.hasNext()) {
            ex = ei.next();
            de.append(", ").append(ex.toText());
        }
        de.append(" ]");
        return de.toString();
    }
}

