/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.cmdline.tokenizer.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerCrossValidator;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.FMeasure;

public final class TokenizerCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "TokenizerCrossValidator";
    }

    public String getShortDescription() {
        return "K-fold cross validator for the learnable tokenizer";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(CVToolParams.class);
    }

    public void run(String[] args) {
        TokenizerCrossValidator validator;
        if (!ArgumentParser.validateArguments(args, CVToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        CVToolParams params = ArgumentParser.parse(args, CVToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), false);
        File trainingDataInFile = params.getData();
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        Charset encoding = params.getEncoding();
        ObjectStream<TokenSample> sampleStream = TokenizerTrainerTool.openSampleData("Training Data", trainingDataInFile, encoding);
        if (mlParams == null) {
            mlParams = TokenizerTrainerTool.createTrainingParameters(params.getIterations(), params.getCutoff());
        }
        TokenEvaluationErrorListener listener = null;
        if (params.getMisclassified().booleanValue()) {
            listener = new TokenEvaluationErrorListener();
        }
        try {
            Dictionary dict = TokenizerTrainerTool.loadDict(params.getAbbDict());
            validator = new TokenizerCrossValidator(params.getLang(), dict, params.getAlphaNumOpt(), mlParams, listener);
            validator.evaluate(sampleStream, params.getFolds());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        FMeasure result = validator.getFMeasure();
        System.out.println(result.toString());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
    }
}

