/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.cmdline.sentdetect.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SDCrossValidator;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.FMeasure;

public final class SentenceDetectorCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "SentenceDetectorCrossValidator";
    }

    public String getShortDescription() {
        return "K-fold cross validator for the learnable sentence detector";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(CVToolParams.class);
    }

    public void run(String[] args) {
        SDCrossValidator validator;
        if (!ArgumentParser.validateArguments(args, CVToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        CVToolParams params = ArgumentParser.parse(args, CVToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), false);
        File trainingDataInFile = params.getData();
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        Charset encoding = params.getEncoding();
        ObjectStream<SentenceSample> sampleStream = SentenceDetectorTrainerTool.openSampleData("Training Data", trainingDataInFile, encoding);
        SentenceEvaluationErrorListener errorListener = null;
        if (params.getMisclassified().booleanValue()) {
            errorListener = new SentenceEvaluationErrorListener();
        }
        if (mlParams == null) {
            mlParams = new TrainingParameters();
            mlParams.put("Algorithm", "MAXENT");
            mlParams.put("Iterations", Integer.toString(params.getIterations()));
            mlParams.put("Cutoff", Integer.toString(params.getCutoff()));
        }
        try {
            Dictionary abbreviations = SentenceDetectorTrainerTool.loadDict(params.getAbbDict());
            validator = new SDCrossValidator(params.getLang(), mlParams, abbreviations, errorListener);
            validator.evaluate(sampleStream, params.getFolds());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        FMeasure result = validator.getFMeasure();
        System.out.println(result.toString());
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams {
    }
}

