/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import opennlp.model.TrainUtil;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.parser.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.parser.treeinsert.Parser;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "ParserTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trains the learnable parser";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(TrainerToolParams.class);
    }

    static ObjectStream<Parse> openTrainingData(File trainingDataFile, Charset encoding) {
        FileInputStream trainingDataIn;
        CmdLineUtil.checkInputFile("Training data", trainingDataFile);
        System.err.print("Opening training data ... ");
        try {
            trainingDataIn = new FileInputStream(trainingDataFile);
        }
        catch (FileNotFoundException e) {
            System.err.println("failed");
            System.err.println("File not found: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        System.err.println("done");
        return new ParseSampleStream(new PlainTextByLineStream(trainingDataIn.getChannel(), encoding));
    }

    static Dictionary buildDictionary(ObjectStream<Parse> parseSamples, opennlp.tools.parser.HeadRules headRules, int cutoff) {
        Dictionary mdict;
        System.err.print("Building dictionary ...");
        try {
            mdict = opennlp.tools.parser.chunking.Parser.buildDictionary(parseSamples, headRules, cutoff);
        }
        catch (IOException e) {
            System.err.println("Error while building dictionary: " + e.getMessage());
            mdict = null;
        }
        System.err.println("done");
        return mdict;
    }

    static ParserType parseParserType(String typeAsString) {
        ParserType type = null;
        if (typeAsString != null && typeAsString.length() > 0 && (type = ParserType.parse(typeAsString)) == null) {
            System.err.println("ParserType training parameter is invalid!");
            throw new TerminateToolException(-1);
        }
        return type;
    }

    @Override
    public void run(String[] args) {
        ParserModel model;
        File modelOutFile;
        block21: {
            if (!ArgumentParser.validateArguments(args, TrainerToolParams.class)) {
                System.err.println(this.getHelp());
                throw new TerminateToolException(1);
            }
            TrainerToolParams params = ArgumentParser.parse(args, TrainerToolParams.class);
            TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), true);
            if (mlParams != null) {
                if (!TrainUtil.isValid(mlParams.getSettings("build"))) {
                    System.err.println("Build training parameters are invalid!");
                    throw new TerminateToolException(-1);
                }
                if (!TrainUtil.isValid(mlParams.getSettings("check"))) {
                    System.err.println("Check training parameters are invalid!");
                    throw new TerminateToolException(-1);
                }
                if (!TrainUtil.isValid(mlParams.getSettings("attach"))) {
                    System.err.println("Attach training parameters are invalid!");
                    throw new TerminateToolException(-1);
                }
                if (!TrainUtil.isValid(mlParams.getSettings("tagger"))) {
                    System.err.println("Tagger training parameters are invalid!");
                    throw new TerminateToolException(-1);
                }
                if (!TrainUtil.isValid(mlParams.getSettings("chunker"))) {
                    System.err.println("Chunker training parameters are invalid!");
                    throw new TerminateToolException(-1);
                }
            }
            ObjectStream<Parse> sampleStream = ParserTrainerTool.openTrainingData(params.getData(), params.getEncoding());
            modelOutFile = params.getModel();
            CmdLineUtil.checkOutputFile("parser model", modelOutFile);
            try {
                HeadRules rules = new HeadRules(new InputStreamReader((InputStream)new FileInputStream(params.getHeadRules()), params.getEncoding()));
                ParserType type = ParserTrainerTool.parseParserType(params.getParserType());
                if (mlParams == null) {
                    if (ParserType.CHUNKING.equals((Object)type)) {
                        model = opennlp.tools.parser.chunking.Parser.train(params.getLang(), sampleStream, rules, params.getIterations(), params.getCutoff());
                        break block21;
                    }
                    if (ParserType.TREEINSERT.equals((Object)type)) {
                        model = Parser.train(params.getLang(), sampleStream, rules, params.getIterations(), params.getCutoff());
                        break block21;
                    }
                    throw new IllegalStateException();
                }
                if (ParserType.CHUNKING.equals((Object)type)) {
                    model = opennlp.tools.parser.chunking.Parser.train(params.getLang(), sampleStream, rules, mlParams);
                    break block21;
                }
                if (ParserType.TREEINSERT.equals((Object)type)) {
                    model = Parser.train(params.getLang(), sampleStream, rules, mlParams);
                    break block21;
                }
                throw new IllegalStateException();
            }
            catch (IOException e) {
                CmdLineUtil.printTrainingIoError(e);
                throw new TerminateToolException(-1);
            }
            finally {
                try {
                    sampleStream.close();
                }
                catch (IOException e) {}
            }
        }
        CmdLineUtil.writeModel("parser", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

