/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InvalidFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSSample {
    private List<String> sentence;
    private List<String> tags;

    public POSSample(String[] sentence, String[] tags) {
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(sentence)));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(tags)));
        this.checkArguments();
    }

    public POSSample(List<String> sentence, List<String> tags) {
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(sentence));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
        this.checkArguments();
    }

    private void checkArguments() {
        if (this.sentence.size() != this.tags.size()) {
            throw new IllegalArgumentException("There must be exactly one tag for each token!");
        }
        if (this.sentence.contains(null) || this.tags.contains(null)) {
            throw new IllegalArgumentException("null elements are not allowed!");
        }
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.getSentence().length; ++i) {
            result.append(this.getSentence()[i]);
            result.append('_');
            result.append(this.getTags()[i]);
            result.append(' ');
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static POSSample parse(String sentenceString) throws InvalidFormatException {
        String[] tokenTags = WhitespaceTokenizer.INSTANCE.tokenize(sentenceString);
        String[] sentence = new String[tokenTags.length];
        String[] tags = new String[tokenTags.length];
        for (int i = 0; i < tokenTags.length; ++i) {
            int split = tokenTags[i].lastIndexOf("_");
            if (split == -1) {
                throw new InvalidFormatException("Cannot find \"_\" inside token!");
            }
            sentence[i] = tokenTags[i].substring(0, split);
            tags[i] = tokenTags[i].substring(split + 1);
        }
        return new POSSample(sentence, tags);
    }
}

