/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.GenericModelReader;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.UncloseableInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class POSModel
extends BaseModel {
    private static final String COMPONENT_NAME = "POSTaggerME";
    private static final String POS_MODEL_ENTRY_NAME = "pos.model";
    private static final String TAG_DICTIONARY_ENTRY_NAME = "tags.tagdict";
    private static final String NGRAM_DICTIONARY_ENTRY_NAME = "ngram.dictionary";

    public POSModel(String languageCode, AbstractModel posModel, POSDictionary tagDictionary, Dictionary ngramDict, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        if (posModel == null) {
            throw new IllegalArgumentException("The maxentPosModel param must not be null!");
        }
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, posModel);
        if (tagDictionary != null) {
            this.artifactMap.put(TAG_DICTIONARY_ENTRY_NAME, tagDictionary);
        }
        if (ngramDict != null) {
            this.artifactMap.put(NGRAM_DICTIONARY_ENTRY_NAME, ngramDict);
        }
    }

    public POSModel(String languageCode, AbstractModel posModel, POSDictionary tagDictionary, Dictionary ngramDict) {
        this(languageCode, posModel, tagDictionary, ngramDict, null);
    }

    public POSModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        POSDictionarySerializer.register(serializers);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("POS model is incomplete!");
        }
        Object tagdictEntry = this.artifactMap.get(TAG_DICTIONARY_ENTRY_NAME);
        if (tagdictEntry != null && !(tagdictEntry instanceof POSDictionary)) {
            throw new InvalidFormatException("Abbreviations dictionary has wrong type!");
        }
        Object ngramDictEntry = this.artifactMap.get(NGRAM_DICTIONARY_ENTRY_NAME);
        if (ngramDictEntry != null && !(ngramDictEntry instanceof Dictionary)) {
            throw new InvalidFormatException("NGram dictionary has wrong type!");
        }
    }

    public AbstractModel getPosModel() {
        return (AbstractModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
    }

    public POSDictionary getTagDictionary() {
        return (POSDictionary)this.artifactMap.get(TAG_DICTIONARY_ENTRY_NAME);
    }

    public Dictionary getNgramDictionary() {
        return (Dictionary)this.artifactMap.get(NGRAM_DICTIONARY_ENTRY_NAME);
    }

    public static void usage() {
        System.err.println("POSModel packageName modelName [tagDictionary] [ngramDictionary]");
    }

    @Deprecated
    public static void main(String[] args) throws IOException, InvalidFormatException {
        if (args.length == 0) {
            POSModel.usage();
            System.exit(1);
        }
        int ai = 0;
        String packageName = args[ai++];
        String modelName = args[ai++];
        AbstractModel model = new GenericModelReader(new File(modelName)).getModel();
        POSDictionary tagDict = null;
        Dictionary ngramDict = null;
        if (ai < args.length) {
            String tagDictName = args[ai++];
            tagDict = new POSDictionary(tagDictName);
            if (ai < args.length) {
                String ngramName = args[ai++];
                ngramDict = new Dictionary(new FileInputStream(ngramName));
            }
        }
        new POSModel("en", model, tagDict, ngramDict).serialize(new FileOutputStream(new File(packageName)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        POSDictionarySerializer() {
        }

        @Override
        public POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return POSDictionary.create(new UncloseableInputStream(in));
        }

        @Override
        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }

        static void register(Map<String, ArtifactSerializer> factories) {
            factories.put("tagdict", new POSDictionarySerializer());
        }
    }
}

