/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.DetokenizerParameter;
import opennlp.tools.formats.NameSampleStreamFactory;
import opennlp.tools.formats.NameToTokenSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameToTokenSampleStreamFactory
implements ObjectStreamFactory<TokenSample> {
    @Override
    public String getUsage() {
        return ArgumentParser.createUsage(Parameters.class);
    }

    @Override
    public boolean validateArguments(String[] args) {
        return ArgumentParser.validateArguments(args, Parameters.class);
    }

    @Override
    public ObjectStream<TokenSample> create(String[] args) {
        DictionaryDetokenizer detokenizer;
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        ObjectStream<NameSample> nameSampleStream = new NameSampleStreamFactory().create(params);
        try {
            detokenizer = new DictionaryDetokenizer(new DetokenizationDictionary(new FileInputStream(new File(params.getDetokenizer()))));
        }
        catch (IOException e) {
            System.err.println("Error while loading detokenizer dict: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        return new NameToTokenSampleStream(detokenizer, nameSampleStream);
    }

    static interface Parameters
    extends NameSampleStreamFactory.Parameters,
    DetokenizerParameter {
    }
}

